"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    BaseRemoteError: function() {
        return BaseRemoteError;
    },
    RemoteCallError: function() {
        return RemoteCallError;
    }
});
const _BaseError = require("../BaseError");
const _constants = require("../constants");
let BaseRemoteError = class BaseRemoteError extends _BaseError.BaseError {
    constructor(type, title, detail){
        super(type, title, 502, detail);
    }
};
let RemoteCallError = class RemoteCallError extends BaseRemoteError {
    constructor(detail){
        super(_constants.ERROR_TYPE.REMOTE, 'Remote call failed', detail);
    }
};

//# sourceMappingURL=RemoteError.js.map