"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FacilitySyncConnection", {
    enumerable: true,
    get: function() {
        return FacilitySyncConnection;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _errors = require("@tamanu/errors");
const _logging = require("@tamanu/shared/services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let FacilitySyncConnection = class FacilitySyncConnection {
    async fetch(endpoint, params = {}) {
        const { body, method = 'GET' } = params;
        const url = `${this.host}/sync/${endpoint}`;
        _logging.log.debug(`[FacilitySyncConnection] ${method} ${url}`);
        const response = await fetch(url, {
            method,
            headers: {
                Accept: 'application/json',
                'Content-Type': body ? 'application/json' : undefined
            },
            body: body && JSON.stringify(body)
        });
        if (!response.ok) {
            throw await (0, _errors.extractErrorFromFetchResponse)(response, url, _logging.log);
        }
        return await response.json();
    }
    async runSync(syncData) {
        return await this.fetch('run', {
            method: 'POST',
            body: {
                syncData
            }
        });
    }
    async getSyncStatus() {
        return await this.fetch('status');
    }
    constructor(){
        this.host = `${_config.default.sync.syncApiConnection.host.trim().replace(/\/*$/, '')}:${_config.default.sync.syncApiConnection.port}`;
    }
};

//# sourceMappingURL=FacilitySyncConnection.js.map