//#region rolldown:runtime
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
	if (from && typeof from === "object" || typeof from === "function") for (var keys = __getOwnPropNames(from), i = 0, n = keys.length, key; i < n; i++) {
		key = keys[i];
		if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
			get: ((k) => from[k]).bind(null, key),
			enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
		});
	}
	return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
	value: mod,
	enumerable: true
}) : target, mod));

//#endregion
const zod_v4_core = __toESM(require("zod/v4/core"));
const __faker_js_faker = __toESM(require("@faker-js/faker"));
const zod_v4 = __toESM(require("zod/v4"));
const randexp = __toESM(require("randexp"));
const zod = __toESM(require("zod"));

//#region src/lib/v4/exceptions.ts
var RecursionLimitReachedException$1 = class extends Error {};
var NoGeneratorException$1 = class extends Error {};
var InvalidSchemaException$1 = class extends Error {};

//#endregion
//#region src/lib/v4/generate.ts
/**
* Generate a random value that matches the given schema.
* This get's called recursively until schema generation is done.
*
* @param schema - The schema to generate a value for.
* @param ctx - The context and configuration for the generation process.
* @returns - A pseudo-random value that matches the given schema.
*/
function generate$1(schema, ctx) {
	increment_recursion_count$1(schema, ctx);
	try {
		return generate_value$1(schema, ctx);
	} finally {
		decrement_recursion_count$1(schema, ctx);
	}
}
const generate_value$1 = (schema, generation_context) => {
	const reference_generator = generation_context.reference_generators.find((g) => g.schema === schema);
	if (reference_generator) return reference_generator.generator(schema, generation_context);
	const instanceof_generator = generation_context.instanceof_generators.find((g) => schema instanceof g.schema);
	if (instanceof_generator) return instanceof_generator.generator(schema, generation_context);
	throw new NoGeneratorException$1(`No generator for schema ${schema._zod.def.type} - You can provide a custom generator in the zocker options`);
};
function increment_recursion_count$1(schema, ctx) {
	const previous_depth = ctx.parent_schemas.get(schema) ?? 0;
	const current_depth = previous_depth + 1;
	if (current_depth >= ctx.recursion_limit) throw new RecursionLimitReachedException$1("Recursion limit reached");
	ctx.parent_schemas.set(schema, current_depth);
}
function decrement_recursion_count$1(schema, ctx) {
	const previous_depth = ctx.parent_schemas.get(schema) ?? 0;
	const current_depth = previous_depth - 1;
	ctx.parent_schemas.set(schema, current_depth);
}

//#endregion
//#region src/lib/v4/utils/random.ts
/**
* @deprecated Use `faker.helpers.arrayElement` directly
*/
function pick$1(array) {
	return __faker_js_faker.faker.helpers.arrayElement(array);
}
/**
* @deprecated Use `faker.datatype.boolean({ probability })` directly
*/
function weighted_random_boolean$1(true_probability) {
	return __faker_js_faker.faker.datatype.boolean({ probability: true_probability });
}

//#endregion
//#region src/lib/v4/generators/default.ts
const generator$5 = (schema, ctx) => {
	const should_use_default = weighted_random_boolean$1(ctx.default_options.default_chance);
	const default_value = schema._zod.def.defaultValue;
	return should_use_default ? default_value : generate$1(schema._zod.def.innerType, ctx);
};
const DefaultGenerator$1 = {
	schema: zod_v4_core.$ZodDefault,
	generator: generator$5,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/any.ts
const literalSchema$1 = zod_v4.union([
	zod_v4.string(),
	zod_v4.number(),
	zod_v4.boolean(),
	zod_v4.null()
]);
const jsonSchema$1 = zod_v4.lazy(() => zod_v4.union([
	literalSchema$1,
	zod_v4.array(jsonSchema$1),
	zod_v4.record(zod_v4.string(), jsonSchema$1)
]));
const any$2 = zod_v4.any();
const potential_schemas$1 = [
	zod_v4.undefined(),
	zod_v4.null(),
	zod_v4.boolean(),
	zod_v4.number(),
	zod_v4.string(),
	zod_v4.bigint(),
	zod_v4.date(),
	zod_v4.symbol(),
	zod_v4.unknown(),
	zod_v4.nan(),
	zod_v4.record(zod_v4.union([
		zod_v4.string(),
		zod_v4.number(),
		zod_v4.symbol()
	]), any$2),
	zod_v4.array(any$2),
	zod_v4.map(any$2, any$2),
	zod_v4.set(any$2),
	zod_v4.promise(any$2)
].map((schema) => schema.optional());
const generate_any$1 = (schema, ctx) => {
	if (ctx.any_options.strategy === "fast") return void 0;
	if (ctx.any_options.strategy === "json-compatible") {
		const generated$1 = generate$1(jsonSchema$1, ctx);
		return generated$1;
	}
	const schema_to_use = pick$1(potential_schemas$1);
	const generated = generate$1(schema_to_use, ctx);
	return generated;
};
const generate_unknown$1 = (schema, ctx) => {
	if (ctx.unknown_options.strategy === "fast") return void 0;
	if (ctx.unknown_options.strategy === "json-compatible") {
		const generated$1 = generate$1(jsonSchema$1, ctx);
		return generated$1;
	}
	const schema_to_use = pick$1(potential_schemas$1);
	const generated = generate$1(schema_to_use, ctx);
	return generated;
};
const AnyGenerator$1 = {
	schema: zod_v4_core.$ZodAny,
	generator: generate_any$1,
	match: "instanceof"
};
const UnknownGenerator$1 = {
	schema: zod_v4_core.$ZodUnknown,
	generator: generate_unknown$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/utils/lcm.ts
/**
* Calculates the least common multiple (LCM) of two numbers.
* @param a
* @param b
* @returns
*/
function lcm$3(a, b) {
	if (a === Number.MIN_VALUE || a == 0) return b;
	if (b === Number.MIN_VALUE || b == 0) return a;
	if (typeof a === "bigint") return bigintLCM(BigInt(a), BigInt(b));
	return lcmNonIntegers(a.toString(), b.toString());
}
/**
* Calculates the greatest common divisor (GCD) of two numbers using the Euclidean algorithm.
*/
function bigintGCD(a, b) {
	while (b !== 0n) [a, b] = [b, a % b];
	return a;
}
/**
* Calculates the least common multiple (LCM) of two numbers.
*/
function bigintLCM(a, b) {
	return a * b / bigintGCD(a, b);
}
/**
* Converts a decimal string to a fraction represented as a tuple of two bigints (numerator, denominator).
* @param decimalStr Eg "0.75" or "1.5"
* @returns A tuple where the first element is the numerator and the second element is the denominator.
*
* @example "0.75" -> [3n, 4n]
*/
function decimalToFraction(decimalStr) {
	if (decimalStr.includes("e")) {
		const [base, exponent] = decimalStr.split("e");
		if (!base || !exponent) throw new Error(`Invalid number string: ${decimalStr}`);
		const baseFraction = decimalToFraction(base);
		const exponentValue = BigInt(exponent);
		if (exponentValue < 0n) baseFraction[1] *= 10n ** -exponentValue;
		else baseFraction[0] *= 10n ** exponentValue;
		return baseFraction;
	}
	if (!decimalStr.includes(".")) return [BigInt(decimalStr), 1n];
	const parts = decimalStr.split(".");
	const intPart = parts[0];
	const fracPart = parts[1] ?? "";
	const scale = 10n ** BigInt(fracPart.length);
	const numerator = BigInt(intPart + fracPart);
	const denominator = scale;
	const divisor = bigintGCD(numerator, denominator);
	return [numerator / divisor, denominator / divisor];
}
/**
*
* @param aStr
* @param bStr
* @returns
*/
function lcmNonIntegers(aStr, bStr) {
	const [numA, denA] = decimalToFraction(aStr);
	const [numB, denB] = decimalToFraction(bStr);
	const lcmDen = bigintLCM(denA, denB);
	const A = numA * (lcmDen / denA);
	const B = numB * (lcmDen / denB);
	const lcmInt = bigintLCM(A, B);
	const result = Number(lcmInt) / Number(lcmDen);
	return Number(result.toString());
}

//#endregion
//#region src/lib/v4/generators/numbers.ts
const generate_number$1 = (number_schema, ctx) => {
	try {
		let proposed_number = NaN;
		const semantic_generators = {
			age: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 120
			}),
			year: () => __faker_js_faker.faker.number.int({
				min: 1200,
				max: 3e3
			}),
			month: () => __faker_js_faker.faker.number.int({
				min: 1,
				max: 12
			}),
			"day-of-the-month": () => __faker_js_faker.faker.number.int({
				min: 1,
				max: 31
			}),
			hour: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 23
			}),
			minute: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 59
			}),
			second: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 59
			}),
			millisecond: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 999
			}),
			weekday: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 6
			})
		};
		const generator$6 = semantic_generators[ctx.semantic_context];
		if (!generator$6) throw new Error("No generator found for semantic context - Falling back to random number");
		proposed_number = generator$6();
		const result = number_schema["~standard"].validate(proposed_number);
		if ("then" in result) throw new Error();
		if (result.issues) throw new Error();
		return result.value;
	} catch (e) {}
	let is_extreme_value = __faker_js_faker.faker.datatype.boolean({ probability: ctx.number_options.extreme_value_chance });
	const formatChecks = number_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckNumberFormat) ?? [];
	if (Object.hasOwn(number_schema._zod.def, "format")) formatChecks.push(number_schema);
	let is_int = formatChecks.reduce((acc, check) => acc || check._zod.def.format === "int32" || check._zod.def.format === "safeint" || check._zod.def.format === "uint32", false);
	const is_finite = true;
	const min_checks = number_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckGreaterThan) ?? [];
	const max_checks = number_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckLessThan) ?? [];
	const min_boundary = min_checks.reduce((prev, curr) => {
		const proposedBoundary = [curr._zod.def.value, curr._zod.def.inclusive];
		return proposedBoundary[0] > prev[0] ? proposedBoundary : prev;
	}, [Number.MIN_SAFE_INTEGER / 2, true]);
	const max_boundary = max_checks.reduce((prev, curr) => {
		const proposedBoundary = [curr._zod.def.value, curr._zod.def.inclusive];
		return proposedBoundary[0] < prev[0] ? proposedBoundary : prev;
	}, [Number.MAX_SAFE_INTEGER / 2, true]);
	let inclusive_min = min_boundary[1];
	let inclusive_max = max_boundary[1];
	let min = min_boundary[0];
	let max = max_boundary[0];
	if (!inclusive_min) {
		const float_step = float_step_size$1(min);
		min += is_int ? 1 : float_step;
	}
	if (!inclusive_max) {
		const float_step = float_step_size$1(max);
		max -= is_int ? 1 : float_step;
	}
	if (max < min) throw new InvalidSchemaException$1("max must be greater than min if specified");
	let value;
	if (is_int) value = __faker_js_faker.faker.number.int({
		min,
		max
	});
	else {
		if (is_extreme_value) {
			const use_lower_extreme = __faker_js_faker.faker.datatype.boolean({ probability: .5 });
			if (use_lower_extreme) value = -Infinity;
			else value = Infinity;
		}
		value = __faker_js_faker.faker.number.float({
			min,
			max
		});
	}
	if (value === void 0) throw new Error("Failed to generate Number. This is a bug in the built-in generator");
	const multipleof_checks = number_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckMultipleOf) ?? [];
	const multipleof = multipleof_checks.reduce((acc, check) => {
		const multipleOf = check._zod.def.value;
		return lcm$3(acc, multipleOf);
	}, Number(multipleof_checks[0]?._zod.def.value ?? Number.MIN_VALUE));
	if (multipleof !== Number.MIN_VALUE) {
		value = is_int ? __faker_js_faker.faker.number.int({
			min,
			max,
			multipleOf: multipleof !== Number.MIN_VALUE ? multipleof : void 0
		}) : __faker_js_faker.faker.number.float({
			min,
			max,
			multipleOf: multipleof !== Number.MIN_VALUE ? multipleof : void 0
		});
		const result = zod_v4.z.number().multipleOf(multipleof).safeParse(value);
		if (!result.success) return generate_number$1(number_schema, ctx);
	}
	return value;
};
function float_step_size$1(n) {
	return Math.max(Number.MIN_VALUE, 2 ** Math.floor(Math.log2(n)) * Number.EPSILON);
}
const NumberGenerator$1 = {
	schema: zod_v4_core.$ZodNumber,
	generator: generate_number$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/tuple.ts
const generate_tuple$1 = (schema, generation_context) => {
	const tuple = schema._zod.def.items.map((item) => generate$1(item, generation_context));
	return tuple;
};
const TupleGenerator$1 = {
	schema: zod_v4_core.$ZodTuple,
	generator: generate_tuple$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/union.ts
const generate_union$1 = (schema, ctx) => {
	const schemas = schema._zod.def.options;
	const possible_indexes = new Array(schemas.length).fill(0).map((_, i) => i);
	const indexes = __faker_js_faker.faker.helpers.shuffle(possible_indexes);
	for (const index of indexes) try {
		ctx.path.push(index);
		const schema$1 = schemas[index];
		return generate$1(schema$1, ctx);
	} catch (e) {
		if (e instanceof RecursionLimitReachedException$1) continue;
		else throw e;
	} finally {
		ctx.path.pop();
	}
	throw new RecursionLimitReachedException$1();
};
const UnionGenerator$1 = {
	schema: zod_v4_core.$ZodUnion,
	generator: generate_union$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/semantics.ts
const paragraph_triggers$1 = [
	"about",
	"description",
	"paragraph",
	"text",
	"body",
	"content"
];
const sentence_triggers$1 = [
	"sentence",
	"line",
	"headline",
	"heading"
];
const jobtitle_triggers$1 = [
	"job",
	"title",
	"position",
	"role",
	"occupation",
	"profession",
	"career"
];
const delimiters$1 = [
	",",
	";",
	":",
	"|",
	"/",
	"\\",
	"-",
	"_",
	" "
];
function get_semantic_flag$1(str) {
	str = str.toLowerCase().trim();
	for (const delimiter of delimiters$1) str = str.split(delimiter).join(" ");
	if (str.includes("name")) {
		if (str.includes("first")) return "firstname";
		if (str.includes("last")) return "lastname";
		return "fullname";
	}
	if (str.includes("street")) return "street";
	if (str.includes("city")) return "city";
	if (str.includes("country")) return "country";
	if (paragraph_triggers$1.some((t) => str.includes(t))) return "paragraph";
	if (sentence_triggers$1.some((t) => str.includes(t))) return "sentence";
	if (str.includes("word")) return "word";
	if (jobtitle_triggers$1.some((t) => str.includes(t))) return "jobtitle";
	if (str.includes("phone")) return "phoneNumber";
	if (str.includes("age")) return "age";
	if (str.includes("hex")) return "color-hex";
	if (str.includes("color")) return "color";
	if (str.includes("zip")) return "zip";
	if (str.includes("week") && str.includes("day")) return "weekday";
	if (str.includes("birthday")) return "birthday";
	if (str.includes("year")) return "year";
	if (str.includes("month")) return "month";
	if (str.includes("day")) return "day-of-the-month";
	if (str.includes("hour")) return "hour";
	if (str.includes("minute")) return "minute";
	if (str.includes("second")) return "second";
	if (str.includes("millisecond")) return "millisecond";
	if (str.includes("gender") || str.includes("sex")) return "gender";
	if (str.includes("municipality") || str.includes("city") || str.includes("town") || str.includes("place") || str.includes("region") || str.includes("state")) return "municipality";
	if (str.includes("id")) return "unique-id";
	return "unspecified";
}

//#endregion
//#region src/lib/v4/generators/object.ts
const generate_object$1 = (object_schema, ctx) => {
	const mock_entries = [];
	Object.entries(object_schema._zod.def.shape).forEach((entry) => {
		const key = entry[0];
		const property_schema = entry[1];
		const prev_semantic_context = ctx.semantic_context;
		const semantic_flag = get_semantic_flag$1(String(key));
		try {
			ctx.path.push(key);
			ctx.semantic_context = semantic_flag;
			const generated_value = generate$1(property_schema, ctx);
			mock_entries.push([key, generated_value]);
		} finally {
			ctx.path.pop();
			ctx.semantic_context = prev_semantic_context;
		}
	});
	return Object.fromEntries(mock_entries);
};
const ObjectGenerator$1 = {
	schema: zod_v4_core.$ZodObject,
	generator: generate_object$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/set.ts
const generate_set$1 = (schema, ctx) => {
	const size = __faker_js_faker.faker.number.int({
		min: ctx.set_options.min,
		max: ctx.set_options.max
	});
	const set = /* @__PURE__ */ new Set();
	try {
		for (let i = 0; i < size; i++) try {
			ctx.path.push(i);
			const value = generate$1(schema._zod.def.valueType, ctx);
			set.add(value);
		} finally {
			ctx.path.pop();
		}
	} catch (error) {
		if (error instanceof RecursionLimitReachedException$1) return set;
		throw error;
	}
	return set;
};
const SetGenerator$1 = {
	schema: zod_v4_core.$ZodSet,
	generator: generate_set$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/map.ts
const generate_map$1 = (schema, ctx) => {
	const size = __faker_js_faker.faker.number.int({
		min: ctx.map_options.min,
		max: ctx.map_options.max
	});
	const map = /* @__PURE__ */ new Map();
	try {
		const keys = [];
		for (let i = 0; i < size; i++) {
			const key = generate$1(schema._zod.def.keyType, ctx);
			keys.push(key);
		}
		for (const key of keys) {
			let prev_semantic_context = ctx.semantic_context;
			try {
				ctx.path.push(key);
				ctx.semantic_context = "key";
				const value = generate$1(schema._zod.def.valueType, ctx);
				map.set(key, value);
			} finally {
				ctx.path.pop();
				ctx.semantic_context = prev_semantic_context;
			}
		}
	} catch (error) {
		if (error instanceof RecursionLimitReachedException$1) return map;
		throw error;
	}
	return map;
};
const MapGenerator$1 = {
	schema: zod_v4_core.$ZodMap,
	generator: generate_map$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/dates.ts
const MIN_DATE = /* @__PURE__ */ new Date(-864e13);
const MAX_DATE = /* @__PURE__ */ new Date(864e13);
const generate_date$1 = (date_schema, ctx) => {
	const min_checks = date_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckGreaterThan) ?? [];
	const max_checks = date_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckLessThan) ?? [];
	const min = min_checks.reduce((acc, check) => {
		const value = check._zod.def.value;
		return value > acc ? value : acc;
	}, MIN_DATE);
	const max = max_checks.reduce((acc, check) => {
		const value = check._zod.def.value;
		return value < acc ? value : acc;
	}, MAX_DATE);
	if (min && max && max < min) throw new InvalidSchemaException$1("max date is less than min date");
	if (min === MIN_DATE && max === MAX_DATE) return __faker_js_faker.faker.date.recent({ days: 100 });
	if (min !== MIN_DATE && max === MAX_DATE) return __faker_js_faker.faker.date.future({ refDate: min });
	if (min === MIN_DATE && max !== MAX_DATE) return __faker_js_faker.faker.date.past({ refDate: max });
	return __faker_js_faker.faker.date.between({
		from: min,
		to: max ?? Date.now() + 1e7
	});
};
const DateGenerator$1 = {
	schema: zod_v4_core.$ZodDate,
	generator: generate_date$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/record.ts
const generate_record$1 = (schema, ctx) => {
	const record = {};
	try {
		const keys = generateKeys(schema, ctx);
		for (const key of keys) {
			let value;
			let prev_semantic_context = ctx.semantic_context;
			try {
				ctx.path.push(key);
				ctx.semantic_context = "key";
				value = generate$1(schema._zod.def.valueType, ctx);
			} finally {
				ctx.path.pop();
				ctx.semantic_context = prev_semantic_context;
			}
			record[key] = value;
		}
	} catch (error) {
		if (error instanceof RecursionLimitReachedException$1) return record;
		throw error;
	}
	return record;
};
/**
* Geneartes keys for a record
* @param schema
* @param ctx
*/
function generateKeys(schema, ctx) {
	const keySchema = schema._zod.def.keyType;
	if (keySchema._zod.values) return [...keySchema._zod.values];
	const numKeys = __faker_js_faker.faker.number.int({
		min: ctx.record_options.min,
		max: ctx.record_options.max
	});
	const keys = [];
	while (keys.length < numKeys) {
		const key = generate$1(schema._zod.def.keyType, ctx);
		if (key != void 0) keys.push(key);
	}
	return keys;
}
const RecordGenerator$1 = {
	schema: zod_v4_core.$ZodRecord,
	generator: generate_record$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/bigint.ts
const generate_bigint$1 = (bigint_schema, ctx) => {
	const multiple_of_checks = bigint_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckMultipleOf) ?? [];
	const min_checks = bigint_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckGreaterThan) ?? [];
	const max_checks = bigint_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckLessThan) ?? [];
	const min = min_checks.reduce((acc, check) => {
		const min$1 = check._zod.def.value;
		return min$1 > acc ? min$1 : acc;
	}, BigInt(Number.MIN_SAFE_INTEGER));
	const max = max_checks.reduce((acc, check) => {
		const max$1 = check._zod.def.value;
		return max$1 < acc ? max$1 : acc;
	}, BigInt(Number.MAX_SAFE_INTEGER));
	const multipleof = multiple_of_checks.reduce((acc, check) => {
		const multipleOf = check._zod.def.value;
		return lcm$2(acc, multipleOf);
	}, 1n);
	let value = __faker_js_faker.faker.number.bigInt({
		min,
		max
	});
	const next_larger_multiple = value + (multipleof - value % multipleof);
	const next_smaller_multiple = value - value % multipleof;
	if (next_larger_multiple <= max) value = next_larger_multiple;
	else if (next_smaller_multiple >= min) value = next_smaller_multiple;
	else throw new InvalidSchemaException$1("Cannot generate a valid BigInt that satisfies the constraints");
	return value;
};
function lcm$2(a, b) {
	return a * b / gcd$2(a, b);
}
function gcd$2(a, b) {
	if (b === 0n) return a;
	return gcd$2(b, a % b);
}
const BigintGenerator$1 = {
	schema: zod_v4_core.$ZodBigInt,
	generator: generate_bigint$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/promise.ts
const generate_promise$1 = (schema, generation_context) => {
	return generate$1(schema._zod.def.innerType, generation_context);
};
const PromiseGenerator$1 = {
	schema: zod_v4_core.$ZodPromise,
	generator: generate_promise$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/lazy.ts
const generate_lazy$1 = (schema, generation_context) => {
	const getter = schema._zod.def.getter();
	return generate$1(getter, generation_context);
};
const LazyGenerator$1 = {
	schema: zod_v4_core.$ZodLazy,
	generator: generate_lazy$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/symbol.ts
const generate_symbol$1 = () => {
	const symbol_key = __faker_js_faker.faker.string.alphanumeric();
	return Symbol.for(symbol_key);
};
const SymbolGenerator$1 = {
	schema: zod_v4_core.$ZodSymbol,
	generator: generate_symbol$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/enum.ts
const generate_enum$1 = (schema, ctx) => {
	const values = Object.values(schema._zod.def.entries);
	const value = pick$1(values);
	return value;
};
const EnumGenerator$1 = {
	schema: zod_v4_core.$ZodEnum,
	generator: generate_enum$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/boolean.ts
const generate_boolean$1 = () => {
	return __faker_js_faker.faker.datatype.boolean();
};
const BooleanGenerator$1 = {
	schema: zod_v4_core.$ZodBoolean,
	generator: generate_boolean$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/string/length-constraints.ts
/**
* Returns the length constraints that apply for a given schema. If multiple constraints
* are specified (eg. multiple min-lengths), the most restrictive is applied
*
* @param string_schema The schema to get length constraints for
* @returns The length constraints
* @throws InvalidSchemaException if the length constraints are impossible to satisfy (eg: min > max)
*/
function getLengthConstraints(string_schema) {
	const min_length_checks = string_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckMinLength) ?? [];
	const max_length_checks = string_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckMaxLength) ?? [];
	const exact_length_checks = string_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckLengthEquals) ?? [];
	const min_length = min_length_checks.reduce((acc, check) => {
		const value = check._zod.def.minimum;
		return value > acc ? value : acc;
	}, 0);
	const max_length = max_length_checks.reduce((acc, check) => {
		const value = check._zod.def.maximum;
		return value < acc ? value : acc;
	}, Infinity);
	if (min_length > max_length) throw new InvalidSchemaException$1("min length is greater than max length");
	let exact_length = null;
	for (const exact_length_check of exact_length_checks) {
		const suggested_length = exact_length_check._zod.def.length;
		if (exact_length == null) exact_length = suggested_length;
		else if (suggested_length != exact_length) throw new InvalidSchemaException$1("Cannot generate a string with conflictung exact length constraints");
	}
	if (exact_length !== null) {
		if (min_length > exact_length) throw new InvalidSchemaException$1("min length is greater than exact length");
		if (max_length < exact_length) throw new InvalidSchemaException$1("max length is less than exact length");
	}
	return {
		min: min_length,
		max: max_length,
		exact: exact_length
	};
}

//#endregion
//#region src/lib/v4/generators/array.ts
const generate_array$1 = (array_schema, ctx) => {
	const length_constraints$1 = getLengthConstraints(array_schema);
	const min = Math.max(length_constraints$1.min, ctx.array_options.min);
	const max = Math.min(length_constraints$1.max, ctx.array_options.max);
	if (min > max) throw new InvalidSchemaException$1("min length is greater than max length");
	const length = length_constraints$1.exact ?? __faker_js_faker.faker.number.int({
		min,
		max
	});
	const generated_array = [];
	try {
		for (let i = 0; i < length; i++) {
			let generated_value;
			try {
				ctx.path.push(i);
				generated_value = generate$1(array_schema._zod.def.element, ctx);
			} finally {
				ctx.path.pop();
			}
			generated_array.push(generated_value);
		}
		return generated_array;
	} catch (error) {
		if (!(error instanceof RecursionLimitReachedException$1)) throw error;
		if (min !== 0) throw error;
		if (length_constraints$1.exact !== null && length_constraints$1.exact !== 0) throw error;
		return [];
	}
};
const ArrayGenerator$1 = {
	schema: zod_v4_core.$ZodArray,
	generator: generate_array$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/optional.ts
const generator$4 = (schema, ctx) => {
	const should_be_undefined = weighted_random_boolean$1(ctx.optional_options.undefined_chance);
	try {
		return should_be_undefined ? void 0 : generate$1(schema._zod.def.innerType, ctx);
	} catch (e) {
		if (e instanceof RecursionLimitReachedException$1) return void 0;
		else throw e;
	}
};
const OptionalGenerator$1 = {
	schema: zod_v4_core.$ZodOptional,
	generator: generator$4,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/nullable.ts
const generator$3 = (schema, ctx) => {
	const should_be_null = weighted_random_boolean$1(ctx.nullable_options.null_chance);
	try {
		return should_be_null ? null : generate$1(schema._zod.def.innerType, ctx);
	} catch (e) {
		if (e instanceof RecursionLimitReachedException$1) return null;
		else throw e;
	}
};
const NullableGenerator$1 = {
	schema: zod_v4_core.$ZodNullable,
	generator: generator$3,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/intersection/index.ts
const generate_intersection$1 = (schema, ctx) => {
	const schema_1 = schema._zod.def.left;
	const schema_2 = schema._zod.def.right;
	const merged = merge_schema$1(schema_1, schema_2);
	return generate$1(merged, ctx);
};
const merge_schema$1 = (schema_1, schema_2) => {
	if (schema_1 instanceof zod_v4_core.$ZodNumber && schema_2 instanceof zod_v4_core.$ZodNumber) {
		const combined = zod_v4.z.number();
		combined._zod.def.checks = [...schema_1._zod.def.checks ?? [], ...schema_2._zod.def.checks ?? []];
		return combined;
	}
	if (schema_1 instanceof zod_v4_core.$ZodString && schema_2 instanceof zod_v4_core.$ZodString) {
		const combined = zod_v4.z.string();
		combined._zod.def.checks = [...schema_1._zod.def.checks ?? [], ...schema_2._zod.def.checks ?? []];
		return combined;
	}
	if (schema_1 instanceof zod_v4_core.$ZodBoolean && schema_2 instanceof zod_v4_core.$ZodBoolean) return zod_v4.z.boolean();
	if (schema_1 instanceof zod_v4_core.$ZodLiteral && schema_2 instanceof zod_v4_core.$ZodLiteral) {
		const common_values = setIntersection(new Set(schema_1._zod.def.values), new Set(schema_2._zod.def.values));
		if (common_values.size === 0) throw new InvalidSchemaException$1("Cannot generate intersection of literal schemas with no common values");
		return zod_v4.z.literal(Array.from(common_values));
	}
	if (schema_1 instanceof zod_v4_core.$ZodSymbol && schema_2 instanceof zod_v4_core.$ZodType) return zod_v4.z.symbol();
	if (schema_1 instanceof zod_v4_core.$ZodUnion && schema_2 instanceof zod_v4_core.$ZodUnion) {
		const combined = [];
		for (const option1 of schema_1._zod.def.options) for (const option2 of schema_2._zod.def.options) try {
			combined.push(merge_schema$1(option1, option2));
		} catch (e) {
			continue;
		}
		if (combined.length == 0) throw new NoGeneratorException$1("Could not generate intersection of unions");
		return zod_v4.z.union(combined);
	}
	if (schema_1 instanceof zod_v4_core.$ZodEnum && schema_2 instanceof zod_v4_core.$ZodEnum) {
		const shared = setIntersection(new Set(Object.values(schema_1._zod.def.entries)), new Set(Object.values(schema_2._zod.def.entries)));
		return zod_v4.z.enum(Array.from(shared));
	}
	if (schema_1 instanceof zod_v4_core.$ZodArray && schema_2 instanceof zod_v4_core.$ZodArray) return zod_v4.z.array(merge_schema$1(schema_1._zod.def.element, schema_2._zod.def.element));
	throw new NoGeneratorException$1("ZodIntersections only have very limited support at the moment.");
};
const IntersectionGenerator$1 = {
	schema: zod_v4_core.$ZodIntersection,
	generator: generate_intersection$1,
	match: "instanceof"
};
function setIntersection(a, b) {
	return new Set([...a].filter((x) => b.has(x)));
}

//#endregion
//#region src/lib/v4/generators/readonly.ts
const generate_readonly$1 = (readonly_schema, ctx) => {
	const inner = generate$1(readonly_schema._zod.def.innerType, ctx);
	if (typeof inner === "object") Object.freeze(inner);
	return inner;
};
const ReadonlyGenerator$1 = {
	schema: zod_v4_core.$ZodReadonly,
	generator: generate_readonly$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/string/content-constraints.ts
/**
* Returns the constraints on the _content_ of a string. These include:
* - `starts_with`, `ends_with` and `includes`
*
* @param string_schema The string schema to get the Content Constarints for.
* @returns The constaraints on the content of the string.
*/
function getContentConstraints(string_schema) {
	const starts_with_checks = string_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckStartsWith) ?? [];
	const ends_with_checks = string_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckEndsWith) ?? [];
	const includes_checks = string_schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckIncludes) ?? [];
	const starts_with = starts_with_checks.reduce((acc, check) => {
		const suggested_starts_with = check._zod.def.prefix;
		if (acc.length == suggested_starts_with.length && acc != suggested_starts_with) throw new InvalidSchemaException$1("startsWith constraints are not compatible - The Schema cannot be satisfied");
		const longer = suggested_starts_with.length > acc.length ? suggested_starts_with : acc;
		const shorter = suggested_starts_with.length < acc.length ? suggested_starts_with : acc;
		if (!longer.startsWith(shorter)) throw new InvalidSchemaException$1("startsWith constraints are not compatible - The Schema cannot be satisfied");
		return longer;
	}, "");
	const ends_with = ends_with_checks.reduce((acc, check) => {
		const suggested_ends_with = check._zod.def.suffix;
		if (acc.length == suggested_ends_with.length && acc != suggested_ends_with) throw new InvalidSchemaException$1("endsWith constraints are not compatible - The Schema cannot be satisfied");
		const longer = suggested_ends_with.length > acc.length ? suggested_ends_with : acc;
		const shorter = suggested_ends_with.length < acc.length ? suggested_ends_with : acc;
		if (!longer.endsWith(shorter)) throw new InvalidSchemaException$1("endsWith constraints are not compatible - The Schema cannot be satisfied");
		return longer;
	}, "");
	const includes = includes_checks.map((c) => c._zod.def.includes).filter((include) => !starts_with.includes(include)).filter((include) => !ends_with.includes(include));
	return {
		starts_with,
		ends_with,
		includes
	};
}

//#endregion
//#region src/lib/v4/generators/string/legacy.ts
/**
* If the schema has checks for a legacy format (eg `z.string().email()` instead of `z.string()`), this will
* call the apropriate generator.
*
* @returns The generated string, or `null` if no legacy format was used
*/
function legacyFormatString(schema, ctx) {
	const checks = schema._zod.def.checks ?? [];
	const format_checks = checks.filter((check) => check instanceof zod_v4.default.ZodStringFormat);
	const date_checks = format_checks.filter((check) => check instanceof zod_v4.default.iso.ZodISODate);
	if (date_checks.length > 0) {
		const date_schema = zod_v4.default.iso.date();
		date_schema._zod.def.checks = checks;
		return generate$1(date_schema, ctx);
	}
	const datetime_checks = format_checks.filter((check) => check instanceof zod_v4.default.iso.ZodISODateTime);
	if (datetime_checks.length > 0) {
		const datetime_schema = zod_v4.default.iso.datetime();
		datetime_schema._zod.def.checks = checks;
		return generate$1(datetime_schema, ctx);
	}
	const duration_checks = format_checks.filter((check) => check instanceof zod_v4.default.iso.ZodISODuration);
	if (duration_checks.length > 0) {
		const duration_schema = zod_v4.default.iso.duration();
		duration_schema._zod.def.checks = checks;
		return generate$1(duration_schema, ctx);
	}
	const time_checks = format_checks.filter((check) => check instanceof zod_v4.default.iso.ZodISOTime);
	if (time_checks.length > 0) {
		const time_schema = zod_v4.default.iso.time();
		time_schema._zod.def.checks = checks;
		return generate$1(time_schema, ctx);
	}
	const email_checks = format_checks.filter((check) => check instanceof zod_v4.default.ZodEmail);
	if (email_checks.length > 0) {
		const email_schema = zod_v4.default.email();
		email_schema._zod.def.checks = checks;
		return generate$1(email_schema, ctx);
	}
	const guid_checks = checks.filter((c) => c instanceof zod_v4.default.ZodGUID);
	if (guid_checks.length > 0) {
		const guid_schema = zod_v4.default.guid();
		guid_schema._zod.def.checks = checks;
		return generate$1(guid_schema, ctx);
	}
	const uuid_checks = checks.filter((c) => c instanceof zod_v4.default.ZodUUID);
	if (uuid_checks.length > 0) {
		const uuid_schema = zod_v4.default.uuid({ version: uuid_checks[0].def.version });
		uuid_schema._zod.def.checks = checks;
		return generate$1(uuid_schema, ctx);
	}
	const url_checks = checks.filter((c) => c instanceof zod_v4.default.ZodURL);
	if (url_checks.length > 0) {
		const url_schema = zod_v4.default.url();
		url_schema._zod.def.checks = checks;
		return generate$1(url_schema, ctx);
	}
	const cuid_checks = checks.filter((c) => c instanceof zod_v4.default.ZodCUID);
	if (cuid_checks.length > 0) {
		const cuid_schema = zod_v4.default.cuid();
		cuid_schema._zod.def.checks = checks;
		return generate$1(cuid_schema, ctx);
	}
	const cuid2_checks = checks.filter((c) => c instanceof zod_v4.default.ZodCUID2);
	if (cuid2_checks.length > 0) {
		const cuid2_schema = zod_v4.default.cuid2();
		cuid2_schema._zod.def.checks = checks;
		return generate$1(cuid2_schema, ctx);
	}
	const ulid_checks = checks.filter((c) => c instanceof zod_v4.default.ZodULID);
	if (ulid_checks.length > 0) {
		const ulid_schema = zod_v4.default.ulid();
		ulid_schema._zod.def.checks = checks;
		return generate$1(ulid_schema, ctx);
	}
	const emoji_checks = checks.filter((c) => c instanceof zod_v4.default.ZodEmoji);
	if (emoji_checks.length > 0) {
		const emoji_schema = zod_v4.default.emoji();
		emoji_schema._zod.def.checks = checks;
		return generate$1(emoji_schema, ctx);
	}
	const nanoid_checks = checks.filter((c) => c instanceof zod_v4.default.ZodNanoID);
	if (nanoid_checks.length > 0) {
		const nanoid_schema = zod_v4.default.nanoid();
		nanoid_schema._zod.def.checks = checks;
		return generate$1(nanoid_schema, ctx);
	}
	const ipv6_checks = checks.filter((c) => c instanceof zod_v4.default.ZodIPv6);
	if (ipv6_checks.length > 0) {
		const ipv6_schema = zod_v4.default.ipv6();
		ipv6_schema._zod.def.checks = checks;
		return generate$1(ipv6_schema, ctx);
	}
	const ipv4_checks = checks.filter((c) => c instanceof zod_v4.default.ZodIPv4);
	if (ipv4_checks.length > 0) {
		const ipv4_schema = zod_v4.default.ipv4();
		ipv4_schema._zod.def.checks = checks;
		return generate$1(ipv4_schema, ctx);
	}
	const e164_checks = checks.filter((c) => c instanceof zod_v4.default.ZodE164);
	if (e164_checks.length > 0) {
		const e164_schema = zod_v4.default.e164();
		e164_schema._zod.def.checks = checks;
		return generate$1(e164_schema, ctx);
	}
	const cidrv4_checks = checks.filter((c) => c instanceof zod_v4.default.ZodCIDRv4);
	if (cidrv4_checks.length > 0) {
		const cidrv4_schema = zod_v4.default.cidrv4();
		cidrv4_schema._zod.def.checks = checks;
		return generate$1(cidrv4_schema, ctx);
	}
	const cidrv6_checks = checks.filter((c) => c instanceof zod_v4.default.ZodCIDRv6);
	if (cidrv6_checks.length > 0) {
		const cidrv6_schema = zod_v4.default.cidrv6();
		cidrv6_schema._zod.def.checks = checks;
		return generate$1(cidrv6_schema, ctx);
	}
	const base64_url_checks = checks.filter((c) => c instanceof zod_v4.default.ZodBase64URL);
	if (base64_url_checks.length > 0) {
		const base64_url_schema = zod_v4.default.base64url();
		base64_url_schema._zod.def.checks = checks;
		return generate$1(base64_url_schema, ctx);
	}
	const base64_checks = checks.filter((c) => c instanceof zod_v4.default.ZodBase64);
	if (base64_checks.length > 0) {
		const base64_schema = zod_v4.default.base64();
		base64_schema._zod.def.checks = checks;
		return generate$1(base64_schema, ctx);
	}
	const jwt_checks = checks.filter((c) => c instanceof zod_v4.default.ZodJWT);
	if (jwt_checks.length > 0) {
		const jwt_schema = zod_v4.default.jwt();
		jwt_schema._zod.def.checks = checks;
		return generate$1(jwt_schema, ctx);
	}
	const ksuid_checks = checks.filter((c) => c instanceof zod_v4.default.ZodKSUID);
	if (ksuid_checks.length > 0) {
		const ksuid_schema = zod_v4.default.ksuid();
		ksuid_schema._zod.def.checks = checks;
		return generate$1(ksuid_schema, ctx);
	}
	const xid_checks = checks.filter((c) => c instanceof zod_v4.default.ZodXID);
	if (xid_checks.length > 0) {
		const xid_schema = zod_v4.default.xid();
		xid_schema._zod.def.checks = checks;
		return generate$1(xid_schema, ctx);
	}
	return null;
}

//#endregion
//#region src/lib/v4/generators/string/plain.ts
const generate_string$1 = (string_schema, ctx) => {
	const legacy = legacyFormatString(string_schema, ctx);
	if (legacy !== null) return legacy;
	const lengthConstraints = getLengthConstraints(string_schema);
	const contentConstraints = getContentConstraints(string_schema);
	const regexConstraints = getRegexConstraints(string_schema);
	if (regexConstraints.length > 0) {
		if (regexConstraints.length > 1) throw new NoGeneratorException$1("Zocker's included regex generator currently does support multiple regex checks on the same string. Provide a custom generator instead.");
		if (lengthConstraints.exact !== null) throw new NoGeneratorException$1("Zocker's included regex generator currently does not work together with length constraints (minLength, maxLength, length). Provide a custom generator instead.");
		if (contentConstraints.starts_with != "" || contentConstraints.ends_with != "" || contentConstraints.includes.length > 0) throw new NoGeneratorException$1("Zocker's included regex generator currently does not work together with startWith, endsWith or includes constraints. Provide a custom generator instead.");
		const regex$1 = regexConstraints[0];
		const randexp$1 = new randexp.default(regex$1);
		randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
			min,
			max
		});
		return randexp$1.gen();
	}
	try {
		const human_readable_string = generateStringWithoutFormat(ctx, lengthConstraints, contentConstraints);
		if (stringMatchesConstraints(human_readable_string, lengthConstraints, contentConstraints)) return human_readable_string;
	} catch (e) {}
	lengthConstraints.min = Math.max(lengthConstraints.min, contentConstraints.starts_with.length, contentConstraints.ends_with.length, ...contentConstraints.includes.map((s) => s.length));
	const length = lengthConstraints.exact ?? __faker_js_faker.faker.number.int({
		min: lengthConstraints.min,
		max: lengthConstraints.max == Infinity ? lengthConstraints.min + 5e4 : lengthConstraints.max
	});
	const generated_length = length - contentConstraints.starts_with.length - contentConstraints.ends_with.length - contentConstraints.includes.reduce((a, b) => a + b.length, 0);
	return contentConstraints.starts_with + __faker_js_faker.faker.string.sample(generated_length) + contentConstraints.includes.join("") + contentConstraints.ends_with;
};
const StringGenerator$1 = {
	schema: zod_v4_core.$ZodString,
	generator: generate_string$1,
	match: "instanceof"
};
/**
* Takes in a ZodType & Returns a list of 0 or more regexes it has to fulfill.
*
* @example `z.string().regex(/abc/) -> [/abc/]`
* @param schema
*/
function getRegexConstraints(schema) {
	const regex_checks = schema._zod.def.checks?.filter((c) => c instanceof zod_v4_core.$ZodCheckRegex) ?? [];
	return regex_checks.map((check) => check._zod.def.pattern);
}
function generateStringWithoutFormat(ctx, lc, cc) {
	const semantic_generators = {
		fullname: __faker_js_faker.faker.person.fullName,
		firstname: __faker_js_faker.faker.person.firstName,
		lastname: __faker_js_faker.faker.person.lastName,
		street: __faker_js_faker.faker.location.street,
		city: __faker_js_faker.faker.location.city,
		country: __faker_js_faker.faker.location.country,
		zip: __faker_js_faker.faker.location.zipCode,
		phoneNumber: __faker_js_faker.faker.phone.number,
		paragraph: __faker_js_faker.faker.lorem.paragraph,
		sentence: __faker_js_faker.faker.lorem.sentence,
		word: __faker_js_faker.faker.lorem.word,
		jobtitle: __faker_js_faker.faker.person.jobTitle,
		color: color$1,
		gender: __faker_js_faker.faker.person.gender,
		municipality: __faker_js_faker.faker.location.city,
		"color-hex": () => __faker_js_faker.faker.color.rgb({
			prefix: "#",
			casing: "lower"
		}),
		weekday: __faker_js_faker.faker.date.weekday,
		"unique-id": __faker_js_faker.faker.string.uuid,
		key: () => __faker_js_faker.faker.lorem.word(),
		unspecified: () => __faker_js_faker.faker.lorem.paragraphs(__faker_js_faker.faker.number.int({
			min: 1,
			max: 5
		}))
	};
	const generator$6 = semantic_generators[ctx.semantic_context];
	if (!generator$6) throw new Error("No semantic generator found for context - falling back to random string");
	const proposed_string = generator$6();
	return proposed_string;
}
function color$1() {
	const generators = [__faker_js_faker.faker.color.human, __faker_js_faker.faker.color.rgb];
	return pick$1(generators)();
}
function stringMatchesConstraints(str, lc, cc) {
	if (lc.exact && str.length !== lc.exact) return false;
	if (lc.min && str.length < lc.min) return false;
	if (lc.max && str.length > lc.max) return false;
	if (cc.starts_with && !str.startsWith(cc.starts_with)) return false;
	if (cc.ends_with && !str.endsWith(cc.ends_with)) return false;
	if (cc.includes.length > 0 && !cc.includes.every((i) => str.includes(i))) return false;
	return true;
}

//#endregion
//#region src/lib/v4/generators/string/cuid.ts
const CUID_MIN_LENGTH = 9;
const CUID_COMMON_LENGHT = 25;
const CUID2_MIN_LENGTH = 2;
const CUID2_COMMON_LENGTH = 24;
/**
* Generates a valid CUID. The CUID format is as follows:
* 1. The char 'c'
* 2. 8 or more characters [a-zA-Z0-9]. Technically more are allowed, just not - or whitespace.
*
* @param schema A CUID Schema
* @param generation_context The relevant generation context
* @returns A CUID that conforms to the given schema
* @throws InvalidSchemaException if the Schema cannot be satisfied
*/
const generate_cuid = (schema, generation_context) => {
	const length_constraints$1 = getLengthConstraints(schema);
	const content_constraints$1 = getContentConstraints(schema);
	const exact_length_too_short = length_constraints$1.exact != null && length_constraints$1.exact < CUID_MIN_LENGTH;
	const max_length_too_short = length_constraints$1.max < CUID_MIN_LENGTH;
	if (exact_length_too_short || max_length_too_short) throw new InvalidSchemaException$1("CUID cannot be less than 9 characters long");
	if (content_constraints$1.starts_with != "" && !content_constraints$1.starts_with.startsWith("c")) throw new InvalidSchemaException$1("CUID must start with a 'c'");
	const length = length_constraints$1.exact ?? __faker_js_faker.faker.number.int({
		min: Math.max(length_constraints$1.min, CUID_MIN_LENGTH),
		max: length_constraints$1.max == Infinity ? length_constraints$1.min + CUID_COMMON_LENGHT : length_constraints$1.max
	});
	return generateCUIDofLength(length);
};
/**
* Generates a valid CUID2. The CUID2 format is as follows:
* - One alpha character
* - 1 or more alphanumeric characters
*
* @param schema A CUID2 Schema
* @param generation_context The relevant generation context
* @returns A CUID2 that conforms to the given schema
* @throws InvalidSchemaException if the Schema cannot be satisfied
*/
const generate_cuid2 = (schema, generation_context) => {
	const length_constraints$1 = getLengthConstraints(schema);
	const content_constraints$1 = getContentConstraints(schema);
	const exact_length_too_short = length_constraints$1.exact != null && length_constraints$1.exact < CUID2_MIN_LENGTH;
	const max_length_too_short = length_constraints$1.max < CUID2_MIN_LENGTH;
	if (exact_length_too_short || max_length_too_short) throw new InvalidSchemaException$1("CUID2 cannot be less than 2 characters long");
	const length = length_constraints$1.exact ?? __faker_js_faker.faker.number.int({
		min: Math.max(length_constraints$1.min, CUID2_MIN_LENGTH),
		max: length_constraints$1.max == Infinity ? length_constraints$1.min + CUID2_COMMON_LENGTH : length_constraints$1.max
	});
	return generateCUID2ofLength(length);
};
const CUIDGenerator = {
	schema: zod_v4_core.$ZodCUID,
	generator: generate_cuid,
	match: "instanceof"
};
const CUID2Generator = {
	schema: zod_v4_core.$ZodCUID2,
	generator: generate_cuid2,
	match: "instanceof"
};
/**
* Generates a CUID of the given length
* @param len The length of the CUID. Must be at least 9
* @returns A CUID of the given length
* @throws If the length is too short
*/
function generateCUIDofLength(len) {
	if (len < CUID_MIN_LENGTH) throw new TypeError("CUID must be at least 9 characters long");
	let cuid$1 = "c" + __faker_js_faker.faker.string.alphanumeric({ length: len - 1 });
	return cuid$1;
}
/**
* Generates a CUID2 of the given length
* @param len The length of the CUID2. Must be at least 2
* @returns A CUID of the given length
* @throws If the length is too short
*/
function generateCUID2ofLength(len) {
	if (len < CUID2_MIN_LENGTH) throw new TypeError("CUID2 must be at least 2 characters long");
	let cuid2$1 = __faker_js_faker.faker.string.alpha({ casing: "lower" }) + __faker_js_faker.faker.string.alphanumeric({
		length: len - 1,
		casing: "lower"
	});
	return cuid2$1;
}

//#endregion
//#region src/lib/v4/generators/string/ip.ts
const IPV4_MIN_LENGTH = 7;
const IPV4_MAX_LENGTH = 15;
const IPV4_NUM_DOTS = 3;
const IPV6_MIN_LENGTH = 3;
const IPV6_MAX_LENGTH = 39;
const IPV6_MIN_LENGTH_WITHOUT_DOUBLE_COLON = 15;
const IPV6_MAX_LENGTH_WITH_DOUBLE_COLON = 36;
const ipv4_generator = (schema, ctx) => {
	const length_constraints$1 = getLengthConstraints(schema);
	const content_constraints$1 = getContentConstraints(schema);
	const min_length_too_long = length_constraints$1.min > IPV4_MAX_LENGTH;
	const max_length_too_short = length_constraints$1.max < IPV4_MIN_LENGTH;
	const exact_length_too_long = length_constraints$1.exact != null && length_constraints$1.exact > IPV4_MAX_LENGTH;
	const exact_length_too_short = length_constraints$1.exact != null && length_constraints$1.exact < IPV4_MIN_LENGTH;
	if (min_length_too_long || max_length_too_short || exact_length_too_long || exact_length_too_short) throw new Error("Invalid length constraints for IPv4");
	const length = length_constraints$1.exact ?? __faker_js_faker.faker.number.int({
		min: Math.max(length_constraints$1.min, IPV4_MIN_LENGTH),
		max: Math.min(length_constraints$1.max, IPV4_MAX_LENGTH)
	});
	return generateIPv4OfLength(length);
};
const ipv6_generator = (schema, ctx) => {
	const length_constraints$1 = getLengthConstraints(schema);
	const content_constraints$1 = getContentConstraints(schema);
	const min_length_too_long = length_constraints$1.min > IPV6_MAX_LENGTH;
	const max_length_too_short = length_constraints$1.max < IPV6_MIN_LENGTH;
	const exact_length_too_long = length_constraints$1.exact != null && length_constraints$1.exact > IPV6_MAX_LENGTH;
	const exact_length_too_short = length_constraints$1.exact != null && length_constraints$1.exact < IPV6_MIN_LENGTH;
	if (min_length_too_long || max_length_too_short || exact_length_too_long || exact_length_too_short) throw new Error("Invalid length constraints for IPv6");
	const length = length_constraints$1.exact ?? __faker_js_faker.faker.number.int({
		min: Math.max(length_constraints$1.min, IPV6_MIN_LENGTH),
		max: Math.min(length_constraints$1.max, IPV6_MAX_LENGTH)
	});
	return generateIPv6OfLength(length);
};
const IPv4Generator = {
	schema: zod_v4_core.$ZodIPv4,
	generator: ipv4_generator,
	match: "instanceof"
};
const IPv6Generator = {
	schema: zod_v4_core.$ZodIPv6,
	generator: ipv6_generator,
	match: "instanceof"
};
/**
* Generates an IPv4 Address of the given length. The length must be such that
* an IPv4 address can be made.
*
* @param length
*/
function generateIPv4OfLength(length) {
	const num_numbers_in_ip = length - IPV4_NUM_DOTS;
	const segment_lengths = partition(num_numbers_in_ip, 4, 1, 3);
	const segments = segment_lengths.map((length$1) => generateIPv4Segment(length$1));
	return segments.join(".");
}
/**
* Generates an IPv6 Address of the given length. The length must be such that
* an IPv6 address can be made.
*
* @param length
*/
function generateIPv6OfLength(length) {
	const should_use_double_colon = ipv6ShouldUseDoubleColon(length);
	const num_segments = choseNumberOfIPv6Segments(length, should_use_double_colon);
	if (!should_use_double_colon) {
		const lengthWithoutColons$1 = length - 7;
		const segment_lengths$1 = partition(lengthWithoutColons$1, num_segments, 1, 4);
		const segments$1 = segment_lengths$1.map((length$1) => generateIPv6Segment(length$1));
		return segments$1.join(":");
	}
	const lengthWithoutColons = length - (num_segments - 1) - 2;
	const segment_lengths = partition(lengthWithoutColons, num_segments, 1, 4);
	const segments = segment_lengths.map((length$1) => generateIPv6Segment(length$1));
	return "::" + segments.join(":");
}
/**
* Generates an IPv4 segment (0-255) of the given length
* @param length How many characters the segment should be. Between 1 and 3
* @returns An IPv4 segment
* @throws TypeError if the length is invalid
*/
function generateIPv4Segment(length) {
	if (length < 1 || length > 3 || !Number.isInteger(length)) throw new TypeError("IPv4 segments must be between 1 and 3 characters long");
	switch (length) {
		case 1: return __faker_js_faker.faker.number.int({
			min: 0,
			max: 9
		}).toString();
		case 2: return __faker_js_faker.faker.number.int({
			min: 10,
			max: 99
		}).toString();
		case 3:
		default: return __faker_js_faker.faker.number.int({
			min: 100,
			max: 255
		}).toString();
	}
}
/**
* Generates a random IPv6 segment (0-ffff) of the given length
* @param length How many characters the segment should be. Between 1 and 4
* @returns An IPv6 segment
* @throws TypeError if the length is invalid
*/
function generateIPv6Segment(length) {
	if (length < 1 || length > 4 || !Number.isInteger(length)) throw new TypeError("IPv6 segments must be between 1 and 4 characters long");
	return __faker_js_faker.faker.string.hexadecimal({
		length,
		prefix: "",
		casing: "lower"
	});
}
/**
* Returns true/false if the IPv6 of the given length should use double colons
* - If it's forced it will always use double colons
* - If it can't use the double colon, it will not
* - Otherwise, random
*
* @param length The length of the IPv6 address.
*/
function ipv6ShouldUseDoubleColon(length) {
	if (length < IPV6_MIN_LENGTH || length > IPV6_MAX_LENGTH || !Number.isInteger(length)) throw new TypeError(`Pv6 addresses must be between ${IPV6_MIN_LENGTH} and ${IPV6_MAX_LENGTH} characters long, ${length} given`);
	if (length < IPV6_MIN_LENGTH_WITHOUT_DOUBLE_COLON) return true;
	if (length > IPV6_MAX_LENGTH_WITH_DOUBLE_COLON) return false;
	return __faker_js_faker.faker.datatype.boolean();
}
/**
* Determine the number of segments in the generated IPv6 address.
* If the target length is really short, we might only be able to have 1 segment
* If the target length is really long, we might be forced to have all 8 segments
*
* @param length
*/
function choseNumberOfIPv6Segments(length, shouldUseDoubleColon) {
	if (shouldUseDoubleColon == false) return 8;
	let max_segments = Math.min(Math.floor((length - 1) / 2), 7);
	const min_segments = Math.max(Math.ceil((length - 1) / 5), 1);
	return __faker_js_faker.faker.number.int({
		min: min_segments,
		max: max_segments
	});
}
/**
* Partitions a total number into a specified number of partitions,
* ensuring each partition has a value between min_partition_size and max_partition_size
*
* @param total The total number to partition.
* @param num_partitions The number of partitions to create.
*
* @param min_partition_size The minimum size of a partition.
* @param max_partition_size The maximum size of a partition.
* @returns An array of partition sizes.
* @throws Error if it's not possible to partition the total into the given constraints.
*/
function partition(total, num_partitions, min_partition_size, max_partition_size) {
	if (total < num_partitions * min_partition_size || total > num_partitions * max_partition_size) throw new Error(`Cannot partition ${total} into ${num_partitions} Partitions, where each partition must be between ${min_partition_size} and ${max_partition_size}.`);
	let remaining = total;
	const partitions = Array(num_partitions).fill(min_partition_size);
	remaining -= num_partitions * min_partition_size;
	while (remaining > 0) {
		const partition_index = __faker_js_faker.faker.number.int({
			min: 0,
			max: num_partitions - 1
		});
		if (partitions[partition_index] >= max_partition_size) continue;
		partitions[partition_index]++;
		remaining--;
	}
	return partitions;
}

//#endregion
//#region src/lib/v4/generators/string/uuid.ts
const uuid_generator = (schema, ctx) => {
	const version = Number.parseInt(schema._zod.def.version?.slice(1) ?? "4");
	if (version == 4 || !version) return __faker_js_faker.faker.string.uuid();
	const pattern = schema._zod.def.pattern ?? zod_v4_core.regexes.uuid(version);
	const randexp$1 = new randexp.default(pattern);
	randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
		min,
		max
	});
	return randexp$1.gen();
};
const UUIDGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodUUID,
	generator: uuid_generator
};
const guid_generator = (schema, ctx) => {
	const pattern = schema._zod.def.pattern ?? zod_v4_core.regexes.guid;
	const randexp$1 = new randexp.default(pattern);
	randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
		min,
		max
	});
	return randexp$1.gen();
};
const GUIDGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodGUID,
	generator: guid_generator
};

//#endregion
//#region src/lib/v4/generators/string/e164.ts
const e164_generator = (schema, ctx) => {
	const pattern = getRegexCheck$1(schema) ?? schema._zod.def.pattern ?? zod_v4_core.regexes.e164;
	const randexp$1 = new randexp.default(pattern);
	randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
		min,
		max
	});
	return randexp$1.gen();
};
const E164Generator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodE164,
	generator: e164_generator
};
function getRegexCheck$1(schema) {
	const checks = schema._zod.def.checks ?? [];
	const regex_checks = checks.filter((check) => check instanceof zod_v4_core.$ZodCheckRegex);
	return regex_checks.at(0)?._zod.def.pattern ?? null;
}

//#endregion
//#region src/lib/v4/generators/string/email.ts
const email_generator = (schema, ctx) => {
	const pattern = getRegexCheck(schema) ?? schema._zod.def.pattern ?? zod_v4_core.regexes.email;
	const generated_email = __faker_js_faker.faker.internet.email();
	if (generated_email.match(pattern)) return generated_email;
	const randexp$1 = new randexp.default(pattern);
	randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
		min,
		max
	});
	return randexp$1.gen();
};
const EmailGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodEmail,
	generator: email_generator
};
function getRegexCheck(schema) {
	const checks = schema._zod.def.checks ?? [];
	const regex_checks = checks.filter((check) => check instanceof zod_v4_core.$ZodCheckRegex);
	return regex_checks.at(0)?._zod.def.pattern ?? null;
}

//#endregion
//#region src/lib/v4/generators/string/iso.ts
const iso_datetime_generator = (schema, ctx) => {
	const offset = schema._zod.def.offset === true;
	const defined_precision = schema._zod.def.precision;
	let precision = defined_precision != null ? defined_precision : __faker_js_faker.faker.number.int({
		min: 0,
		max: 6
	});
	let datetime$1 = __faker_js_faker.faker.date.recent({ days: 100 }).toISOString();
	const PRECISION_REGEX = /(\.\d+)?Z/;
	datetime$1 = datetime$1.replace(PRECISION_REGEX, "Z");
	if (precision > 0) {
		const number = __faker_js_faker.faker.number.int({
			min: 0,
			max: Math.pow(10, precision) - 1
		});
		const replacement = `.${number.toString().padStart(precision, "0")}Z`;
		datetime$1 = datetime$1.replace("Z", replacement);
	}
	if (offset) {
		const hours_number = __faker_js_faker.faker.number.int({
			min: 0,
			max: 23
		});
		const minutes_number = __faker_js_faker.faker.number.int({
			min: 0,
			max: 59
		});
		const hours = hours_number.toString().padStart(2, "0");
		const minutes = minutes_number.toString().padStart(2, "0");
		const sign = __faker_js_faker.faker.datatype.boolean({ probability: .5 }) ? "+" : "-";
		datetime$1 = datetime$1.replace("Z", `${sign}${hours}:${minutes}`);
	}
	return datetime$1;
};
const ISODateTimeGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodISODateTime,
	generator: iso_datetime_generator
};
const iso_date_generator = (schema, ctx) => {
	const date = __faker_js_faker.faker.date.recent({ days: 100 }).toISOString().split("T")[0];
	if (!date) throw new Error("INTERNAL ERROR - ISODateGenerator - `date` is undefined - Please open an issue.");
	return date;
};
const ISODateGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodISODate,
	generator: iso_date_generator
};
const iso_time_generator = (schema, ctx) => {
	const pattern = schema._zod.def.pattern;
	const randexp$1 = new randexp.default(pattern);
	randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
		min,
		max
	});
	const time = randexp$1.gen();
	return time;
};
const ISOTimeGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodISOTime,
	generator: iso_time_generator
};
const iso_duration_generator = (schema, ctx) => {
	const parts = [
		__faker_js_faker.faker.number.int({
			min: 0,
			max: 100
		}),
		__faker_js_faker.faker.number.int({
			min: 0,
			max: 11
		}),
		__faker_js_faker.faker.number.int({
			min: 0,
			max: 31
		}),
		__faker_js_faker.faker.number.int({
			min: 0,
			max: 23
		}),
		__faker_js_faker.faker.number.int({
			min: 0,
			max: 59
		}),
		__faker_js_faker.faker.number.int({
			min: 0,
			max: 59
		})
	];
	let result = `P${parts[0]}Y${parts[1]}M${parts[2]}DT${parts[3]}H${parts[4]}M${parts[5]}S`;
	return result;
};
const ISODurationGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodISODuration,
	generator: iso_duration_generator
};

//#endregion
//#region src/lib/v4/generators/string/nanoid.ts
const nanoid_generator = (schema, ctx) => {
	const pattern = zod_v4_core.regexes.nanoid;
	const randexp$1 = new randexp.default(pattern);
	randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
		min,
		max
	});
	return randexp$1.gen();
};
const NanoIDGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodNanoID,
	generator: nanoid_generator
};

//#endregion
//#region src/lib/v4/generators/string/ulid.ts
const ULID_LENGTH = 26;
const ULID_CHARS = [..."0123456789ABCDEFGHJKMNPQRSTVWXYZ"];
const ulid_generator = (schema, ctx) => {
	const length_constraints$1 = getLengthConstraints(schema);
	const content_constraints$1 = getContentConstraints(schema);
	const min_length_too_long = length_constraints$1.min > ULID_LENGTH;
	const max_length_too_short = length_constraints$1.max < ULID_LENGTH;
	const exact_length_wrong = length_constraints$1.exact != null && length_constraints$1.exact != ULID_LENGTH;
	const starts_with_too_long = content_constraints$1.starts_with.length > ULID_LENGTH;
	const ends_with_too_long = content_constraints$1.ends_with.length > ULID_LENGTH;
	const includes_too_long = content_constraints$1.includes.some((i) => i.length > ULID_LENGTH);
	if (min_length_too_long || max_length_too_short || exact_length_wrong || starts_with_too_long || ends_with_too_long || includes_too_long) throw new Error("Invalid length constraints for ULID. All valid ULIDs are 26 characters long");
	let ulid$1 = content_constraints$1.starts_with + content_constraints$1.includes.join("");
	const generated_length = ULID_LENGTH - ulid$1.length - content_constraints$1.ends_with.length;
	for (let i = 0; i < generated_length; i++) ulid$1 += __faker_js_faker.faker.helpers.arrayElement(ULID_CHARS);
	ulid$1 += content_constraints$1.ends_with;
	return ulid$1;
};
const ULIDGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodULID,
	generator: ulid_generator
};

//#endregion
//#region src/lib/v4/generators/string/cidr.ts
const CIDR_V4_MIN_LENGTH = 9;
const CIDR_V4_MAX_LENGTH = 18;
const CIDR_V6_MIN_LENGTH = 5;
const CIDR_V6_MAX_LENGTH = 43;
const cidrv4_generator = (schema, ctx) => {
	const length_constraints$1 = getLengthConstraints(schema);
	const max_length_too_short = length_constraints$1.max < CIDR_V4_MIN_LENGTH;
	const min_length_too_long = length_constraints$1.min > CIDR_V4_MAX_LENGTH;
	const exact_length_too_short = length_constraints$1.exact && length_constraints$1.exact < CIDR_V4_MIN_LENGTH;
	const exact_length_too_long = length_constraints$1.exact && length_constraints$1.exact > CIDR_V4_MAX_LENGTH;
	if (max_length_too_short || exact_length_too_short || min_length_too_long || exact_length_too_long) throw new InvalidSchemaException$1(`CIDRv4 must be between ${CIDR_V4_MIN_LENGTH} and ${CIDR_V4_MAX_LENGTH} characters long`);
	const length = length_constraints$1.exact ?? __faker_js_faker.faker.number.int({
		min: Math.max(length_constraints$1.min, CIDR_V4_MIN_LENGTH),
		max: Math.min(length_constraints$1.max, CIDR_V4_MAX_LENGTH)
	});
	const must_have_single_digit_mask = length == CIDR_V4_MIN_LENGTH;
	const must_have_double_digit_mask = length == CIDR_V4_MAX_LENGTH;
	let mask_length;
	if (must_have_single_digit_mask) mask_length = 1;
	else if (must_have_double_digit_mask) mask_length = 2;
	else mask_length = __faker_js_faker.faker.number.int({
		min: 1,
		max: 2
	});
	const mask = mask_length == 1 ? __faker_js_faker.faker.number.int({
		min: 0,
		max: 9
	}) : __faker_js_faker.faker.number.int({
		min: 10,
		max: 32
	});
	const ipv4_length = length - mask_length - 1;
	const ipv4_address = generateIPv4OfLength(ipv4_length);
	return `${ipv4_address}/${mask}`;
};
const cidrv6_generator = (schema, ctx) => {
	const length_constraints$1 = getLengthConstraints(schema);
	const max_length_too_short = length_constraints$1.max < CIDR_V6_MIN_LENGTH;
	const min_length_too_long = length_constraints$1.min > CIDR_V6_MAX_LENGTH;
	const exact_length_too_short = length_constraints$1.exact && length_constraints$1.exact < CIDR_V6_MIN_LENGTH;
	const exact_length_too_long = length_constraints$1.exact && length_constraints$1.exact > CIDR_V6_MAX_LENGTH;
	if (max_length_too_short || exact_length_too_short || min_length_too_long || exact_length_too_long) throw new InvalidSchemaException$1(`CIDRv6 must be between ${CIDR_V6_MIN_LENGTH} and ${CIDR_V6_MAX_LENGTH} characters long`);
	const length = length_constraints$1.exact ?? __faker_js_faker.faker.number.int({
		min: Math.max(length_constraints$1.min, CIDR_V6_MIN_LENGTH),
		max: Math.min(length_constraints$1.max, CIDR_V6_MAX_LENGTH)
	});
	const must_have_single_digit_mask = length == CIDR_V6_MIN_LENGTH;
	const cannot_have_triple_digit_mask = length <= CIDR_V4_MIN_LENGTH + 1;
	const cannot_have_single_digit_mask = length >= CIDR_V4_MAX_LENGTH - 1;
	const must_have_triple_digit_mask = length == CIDR_V6_MAX_LENGTH;
	let mask_length;
	if (must_have_single_digit_mask) mask_length = 1;
	else if (must_have_triple_digit_mask) mask_length = 3;
	else mask_length = __faker_js_faker.faker.number.int({
		min: 1,
		max: 3
	});
	if (mask_length == 3 && cannot_have_triple_digit_mask) mask_length = 2;
	if (mask_length == 1 && cannot_have_single_digit_mask) mask_length = 2;
	const mask = mask_length == 1 ? __faker_js_faker.faker.number.int({
		min: 0,
		max: 9
	}) : mask_length == 2 ? __faker_js_faker.faker.number.int({
		min: 10,
		max: 99
	}) : __faker_js_faker.faker.number.int({
		min: 100,
		max: 128
	});
	const ipv6_length = length - mask_length - 1;
	const ipv6_address = generateIPv6OfLength(ipv6_length);
	return `${ipv6_address}/${mask}`;
};
const CIDRv4Generator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodCIDRv4,
	generator: cidrv4_generator
};
const CIDRv6Generator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodCIDRv6,
	generator: cidrv6_generator
};

//#endregion
//#region src/lib/v4/generators/string/url.ts
const url_generator = (schema, ctx) => {
	const hostnameRegex = schema._zod.def.hostname;
	const protocolRegex = schema._zod.def.protocol;
	const length_constraints$1 = getLengthConstraints(schema);
	const content_constraints$1 = getContentConstraints(schema);
	const generated_url = new URL(__faker_js_faker.faker.internet.url());
	if (hostnameRegex !== void 0) generated_url.hostname = generateURLSafeStringForRegex(hostnameRegex);
	if (protocolRegex !== void 0) generated_url.protocol = generateURLSafeStringForRegex(protocolRegex);
	return generated_url.href;
};
const URLGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodURL,
	generator: url_generator
};
function generateURLSafeStringForRegex(regex$1) {
	const randexp$1 = new randexp.default(regex$1);
	randexp$1.defaultRange.subtract(0, 127);
	randexp$1.defaultRange.add(97, 122);
	randexp$1.defaultRange.add(48, 57);
	randexp$1.defaultRange.add(45, 45);
	randexp$1.defaultRange.add(65, 90);
	randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
		min,
		max
	});
	return randexp$1.gen();
}

//#endregion
//#region src/lib/v4/generators/pipe.ts
const pipe_generator = (schema, ctx) => {
	const first = schema._zod.def.in;
	const second = schema._zod.def.out;
	if (!(second instanceof zod_v4_core.$ZodTransform)) return generate$1(second, ctx);
	const transform_function = second._zod.def.transform;
	const value = generate$1(first, ctx);
	const transformed = transform_function(value, {
		issues: [],
		value
	});
	return transformed;
};
const PipeGenerator = {
	schema: zod_v4_core.$ZodPipe,
	generator: pipe_generator,
	match: "instanceof"
};

//#endregion
//#region src/lib/v4/generators/string/emoji.ts
const generate_emoji = (schema, ctx) => {
	const lengthConstraints = getLengthConstraints(schema);
	const contentConstraints = getContentConstraints(schema);
	const length = lengthConstraints.exact ?? __faker_js_faker.faker.number.int({
		min: lengthConstraints.min,
		max: lengthConstraints.max == Infinity ? lengthConstraints.min + 5e4 : lengthConstraints.max
	});
	const generated_length = length - contentConstraints.starts_with.length - contentConstraints.ends_with.length;
	let emojis = contentConstraints.starts_with;
	for (let i = 0; i < length; i++) emojis += __faker_js_faker.faker.internet.emoji();
	emojis += contentConstraints.ends_with;
	return emojis;
};
const EmojiGenerator = {
	match: "instanceof",
	generator: generate_emoji,
	schema: zod_v4_core.$ZodEmoji
};

//#endregion
//#region src/lib/v4/generators/string/base64.ts
const base64_generator = (schema, ctx) => {
	return generateBase64String();
};
const base64url_generator = (schema, ctx) => {
	const data = generateBase64String();
	const encodedData = data.replaceAll("+", "-").replaceAll("/", "_").replaceAll("=", "");
	return encodedData;
};
const Base64Generator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodBase64,
	generator: base64_generator
};
const Base64URLGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodBase64URL,
	generator: base64url_generator
};
function generateBase64String() {
	const bytes = __faker_js_faker.faker.number.int({
		min: 0,
		max: 1e5
	});
	let data = "";
	for (let i = 0; i < bytes; i++) data += String.fromCharCode(__faker_js_faker.faker.number.int({
		min: 0,
		max: 255
	}));
	return btoa(data);
}

//#endregion
//#region src/lib/v4/generators/string/ksuid.ts
const KSUID_LENGTH = 27;
const ksuid_generator = (schema, ctx) => {
	const length_constraints$1 = getLengthConstraints(schema);
	const min_length_too_long = length_constraints$1.min > KSUID_LENGTH;
	const max_length_too_short = length_constraints$1.max < KSUID_LENGTH;
	const exact_length_too_long = length_constraints$1.exact != null && length_constraints$1.exact > KSUID_LENGTH;
	const exact_length_too_short = length_constraints$1.exact != null && length_constraints$1.exact < KSUID_LENGTH;
	if (min_length_too_long || max_length_too_short || exact_length_too_long || exact_length_too_short) throw new Error(`KSUID must be exactly ${KSUID_LENGTH} characters long`);
	const content_constraints$1 = getContentConstraints(schema);
	const ksuid = new randexp.default(zod_v4_core.regexes.ksuid);
	return ksuid.gen();
};
const KSUIDGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodKSUID,
	generator: ksuid_generator
};

//#endregion
//#region src/lib/v4/generators/string/xid.ts
const XID_LENGTH = 20;
const xid_generator = (schema, ctx) => {
	const pattern = schema._zod.def.pattern ?? zod_v4_core.regexes.xid;
	const length_constraints$1 = getLengthConstraints(schema);
	const min_length_too_long = length_constraints$1.min > XID_LENGTH;
	const max_length_too_short = length_constraints$1.max < XID_LENGTH;
	const exact_length_too_long = length_constraints$1.exact != null && length_constraints$1.exact > XID_LENGTH;
	const exact_length_too_short = length_constraints$1.exact != null && length_constraints$1.exact < XID_LENGTH;
	if (min_length_too_long || max_length_too_short || exact_length_too_long || exact_length_too_short) throw new Error(`XID must be exactly ${XID_LENGTH} characters long`);
	const randexp$1 = new randexp.default(pattern);
	randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
		min,
		max
	});
	return randexp$1.gen();
};
const XIDGenerator = {
	match: "instanceof",
	schema: zod_v4_core.$ZodXID,
	generator: xid_generator
};

//#endregion
//#region src/lib/v4/default_generators.ts
const default_generators$1 = [
	XIDGenerator,
	KSUIDGenerator,
	Base64Generator,
	Base64URLGenerator,
	EmojiGenerator,
	URLGenerator,
	CIDRv4Generator,
	CIDRv6Generator,
	ULIDGenerator,
	NanoIDGenerator,
	ISODateGenerator,
	ISODateTimeGenerator,
	ISOTimeGenerator,
	ISODurationGenerator,
	EmailGenerator,
	E164Generator,
	GUIDGenerator,
	UUIDGenerator,
	IPv4Generator,
	IPv6Generator,
	CUID2Generator,
	CUIDGenerator,
	StringGenerator$1,
	NumberGenerator$1,
	BigintGenerator$1,
	BooleanGenerator$1,
	DateGenerator$1,
	SymbolGenerator$1,
	OptionalGenerator$1,
	NullableGenerator$1,
	AnyGenerator$1,
	UnknownGenerator$1,
	PipeGenerator,
	ArrayGenerator$1,
	TupleGenerator$1,
	RecordGenerator$1,
	MapGenerator$1,
	SetGenerator$1,
	ObjectGenerator$1,
	UnionGenerator$1,
	EnumGenerator$1,
	DefaultGenerator$1,
	PromiseGenerator$1,
	LazyGenerator$1,
	ReadonlyGenerator$1,
	{
		schema: zod_v4_core.$ZodVoid,
		generator: () => {},
		match: "instanceof"
	},
	{
		schema: zod_v4_core.$ZodUndefined,
		generator: () => void 0,
		match: "instanceof"
	},
	{
		schema: zod_v4_core.$ZodNull,
		generator: () => null,
		match: "instanceof"
	},
	{
		schema: zod_v4_core.$ZodNaN,
		generator: () => NaN,
		match: "instanceof"
	},
	{
		schema: zod_v4_core.$ZodLiteral,
		generator: (schema) => schema._zod.def.values[0],
		match: "instanceof"
	},
	{
		schema: zod_v4_core.$ZodNever,
		generator: () => void 0,
		match: "instanceof"
	},
	IntersectionGenerator$1
];

//#endregion
//#region src/lib/v4/zocker.ts
function zocker$1(schema) {
	return new Zocker$1(schema);
}
var Zocker$1 = class {
	instanceof_generators = [...default_generators$1];
	reference_generators = [];
	seed = void 0;
	recursion_limit = 5;
	number_options = { extreme_value_chance: .3 };
	optional_options = { undefined_chance: .3 };
	nullable_options = { null_chance: .3 };
	default_options = { default_chance: .3 };
	map_options = {
		max: 10,
		min: 0
	};
	record_options = {
		max: 10,
		min: 0
	};
	set_options = {
		max: 10,
		min: 0
	};
	any_options = { strategy: "true-any" };
	unknown_options = { strategy: "true-any" };
	array_options = {
		min: 0,
		max: 10
	};
	object_options = { generate_extra_keys: true };
	constructor(schema) {
		this.schema = schema;
	}
	/**
	* Supply your own value / function for generating values for a given schema
	* It will be used whenever the given schema matches an encountered schema by referebce
	*
	* @param schema - The schema for which this value will be used
	* @param generator - A value, or a function that generates a value that matches the schema
	*/
	supply(schema, generator$6) {
		const next = this.clone();
		const generator_function = typeof generator$6 === "function" ? generator$6 : () => generator$6;
		next.reference_generators = [{
			schema,
			generator: generator_function,
			match: "reference"
		}, ...next.reference_generators];
		return next;
	}
	/**
	* Override one of the built-in generators using your own.
	* It will be used whenever an encoutntered Schema matches the one specified by **instance**
	*
	* @param schema - Which schema to override. E.g: `z.ZodNumber`.
	* @param generator - A value, or a function that generates a value that matches the schema
	*/
	override(schema, generator$6) {
		const next = this.clone();
		const generator_function = typeof generator$6 === "function" ? generator$6 : () => generator$6;
		const resolved_schema = typeof schema !== "string" ? schema : OVERRIDE_NAMES$1[schema];
		next.instanceof_generators = [{
			schema: resolved_schema,
			generator: generator_function,
			match: "instanceof"
		}, ...next.instanceof_generators];
		return next;
	}
	setSeed(seed) {
		const next = this.clone();
		next.seed = seed;
		return next;
	}
	setDepthLimit(limit) {
		const next = this.clone();
		next.recursion_limit = limit;
		return next;
	}
	number(options) {
		const next = this.clone();
		next.number_options = {
			...next.number_options,
			...options
		};
		return next;
	}
	optional(options) {
		const next = this.clone();
		next.optional_options = {
			...next.optional_options,
			...options
		};
		return next;
	}
	nullable(options) {
		const next = this.clone();
		next.nullable_options = {
			...next.nullable_options,
			...options
		};
		return next;
	}
	default(options) {
		const next = this.clone();
		next.default_options = {
			...next.default_options,
			...options
		};
		return next;
	}
	map(options) {
		const next = this.clone();
		next.map_options = {
			...next.map_options,
			...options
		};
		return next;
	}
	record(options) {
		const next = this.clone();
		next.record_options = {
			...next.record_options,
			...options
		};
		return next;
	}
	set(options) {
		const next = this.clone();
		next.set_options = {
			...next.set_options,
			...options
		};
		return next;
	}
	any(options) {
		const next = this.clone();
		next.any_options = {
			...next.any_options,
			...options
		};
		return next;
	}
	unknown(options) {
		const next = this.clone();
		next.unknown_options = {
			...next.unknown_options,
			...options
		};
		return next;
	}
	array(options) {
		const next = this.clone();
		next.array_options = {
			...next.array_options,
			...options
		};
		return next;
	}
	object(options) {
		const next = this.clone();
		next.object_options = {
			...next.object_options,
			...options
		};
		return next;
	}
	generate() {
		const ctx = {
			reference_generators: this.reference_generators,
			instanceof_generators: this.instanceof_generators,
			recursion_limit: this.recursion_limit,
			path: [],
			semantic_context: "unspecified",
			parent_schemas: /* @__PURE__ */ new Map(),
			seed: this.seed ?? Math.random() * 1e7,
			number_options: this.number_options,
			optional_options: this.optional_options,
			nullable_options: this.nullable_options,
			default_options: this.default_options,
			map_options: this.map_options,
			record_options: this.record_options,
			set_options: this.set_options,
			any_options: this.any_options,
			unknown_options: this.unknown_options,
			array_options: this.array_options,
			object_options: this.object_options
		};
		__faker_js_faker.faker.seed(ctx.seed);
		return generate$1(this.schema, ctx);
	}
	generateMany(count) {
		let previous_seed = this.seed;
		const results = [];
		for (let i = 0; i < count; i++) {
			if (previous_seed !== void 0) this.seed = previous_seed + i;
			results.push(this.generate());
		}
		this.seed = previous_seed;
		return results;
	}
	clone() {
		return Object.create(Object.getPrototypeOf(this), Object.getOwnPropertyDescriptors(this));
	}
};
const OVERRIDE_NAMES$1 = {
	number: zod_v4_core.$ZodNumber,
	string: zod_v4_core.$ZodString,
	boolean: zod_v4_core.$ZodBoolean,
	bigint: zod_v4_core.$ZodBigInt,
	date: zod_v4_core.$ZodDate,
	undefined: zod_v4_core.$ZodUndefined,
	null: zod_v4_core.$ZodNull,
	any: zod_v4_core.$ZodAny,
	unknown: zod_v4_core.$ZodUnknown,
	void: zod_v4_core.$ZodVoid,
	never: zod_v4_core.$ZodNever,
	array: zod_v4_core.$ZodArray,
	object: zod_v4_core.$ZodObject,
	union: zod_v4_core.$ZodUnion,
	intersection: zod_v4_core.$ZodIntersection,
	tuple: zod_v4_core.$ZodTuple,
	record: zod_v4_core.$ZodRecord,
	map: zod_v4_core.$ZodMap,
	set: zod_v4_core.$ZodSet,
	lazy: zod_v4_core.$ZodLazy,
	literal: zod_v4_core.$ZodLiteral,
	enum: zod_v4_core.$ZodEnum,
	promise: zod_v4_core.$ZodPromise,
	transformer: zod_v4_core.$ZodTransform,
	optional: zod_v4_core.$ZodOptional,
	nullable: zod_v4_core.$ZodNullable
};

//#endregion
//#region src/lib/v3/exceptions.ts
var RecursionLimitReachedException = class extends Error {};
var NoGeneratorException = class extends Error {};
var InvalidSchemaException = class extends Error {};

//#endregion
//#region src/lib/v3/generate.ts
/**
* Generate a random value that matches the given schema.
* This get's called recursively until schema generation is done.
*
* @param schema - The schema to generate a value for.
* @param ctx - The context and configuration for the generation process.
* @returns - A pseudo-random value that matches the given schema.
*/
function generate(schema, ctx) {
	increment_recursion_count(schema, ctx);
	try {
		return generate_value(schema, ctx);
	} finally {
		decrement_recursion_count(schema, ctx);
	}
}
const generate_value = (schema, generation_context) => {
	const reference_generator = generation_context.reference_generators.find((g) => g.schema === schema);
	if (reference_generator) return reference_generator.generator(schema, generation_context);
	const instanceof_generator = generation_context.instanceof_generators.find((generator$6) => {
		if (schema instanceof generator$6.schema) return true;
		const generatorSchemaName = generator$6.schema.name;
		const schemaTypeName = schema._def?.typeName;
		if (generatorSchemaName && schemaTypeName) return generatorSchemaName === schemaTypeName;
		return false;
	});
	if (instanceof_generator) return instanceof_generator.generator(schema, generation_context);
	throw new NoGeneratorException(`No generator for schema ${schema} - You can provide a custom generator in the zocker options`);
};
function increment_recursion_count(schema, ctx) {
	const previous_depth = ctx.parent_schemas.get(schema) ?? 0;
	const current_depth = previous_depth + 1;
	if (current_depth >= ctx.recursion_limit) throw new RecursionLimitReachedException("Recursion limit reached");
	ctx.parent_schemas.set(schema, current_depth);
}
function decrement_recursion_count(schema, ctx) {
	const previous_depth = ctx.parent_schemas.get(schema) ?? 0;
	const current_depth = previous_depth - 1;
	ctx.parent_schemas.set(schema, current_depth);
}

//#endregion
//#region src/lib/v3/utils/random.ts
function pick(array) {
	const index = __faker_js_faker.faker.number.int({
		min: 0,
		max: array.length - 1
	});
	if (array.hasOwnProperty(index)) return array[index];
	else throw new Error(`Index ${index} does not exist in array ${array}`);
}
/**
* Randomly pick between two option, with a given probability of picking the first option.
* @param probability - The probability of choosing option_1 (between 0 and 1)
*/
function weighted_pick(option_1, option_2, probability) {
	if (probability <= 0) return option_2;
	if (probability >= 1) return option_1;
	const random = __faker_js_faker.faker.number.float({
		min: 0,
		max: 1
	});
	if (random < probability) return option_1;
	else return option_2;
}
function weighted_random_boolean(true_probability) {
	return weighted_pick(true, false, true_probability);
}

//#endregion
//#region src/lib/v3/generators/default.ts
const generator$2 = (schema, ctx) => {
	const should_use_default = weighted_random_boolean(ctx.default_options.default_chance);
	const default_value = schema._def.defaultValue;
	return should_use_default ? default_value() : generate(schema._def.innerType, ctx);
};
const DefaultGenerator = {
	schema: zod.z.ZodDefault,
	generator: generator$2,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/any.ts
const literalSchema = zod.z.union([
	zod.z.string(),
	zod.z.number(),
	zod.z.boolean(),
	zod.z.null()
]);
const jsonSchema = zod.z.lazy(() => zod.z.union([
	literalSchema,
	zod.z.array(jsonSchema),
	zod.z.record(jsonSchema)
]));
const any$1 = zod.z.any();
const potential_schemas = [
	zod.z.undefined(),
	zod.z.null(),
	zod.z.boolean(),
	zod.z.number(),
	zod.z.string(),
	zod.z.bigint(),
	zod.z.date(),
	zod.z.symbol(),
	zod.z.unknown(),
	zod.z.nan(),
	zod.z.record(any$1),
	zod.z.array(any$1),
	zod.z.map(any$1, any$1),
	zod.z.set(any$1),
	zod.z.promise(any$1)
].map((schema) => schema.optional());
const generate_any = (schema, ctx) => {
	if (ctx.any_options.strategy === "fast") return void 0;
	if (ctx.any_options.strategy === "json-compatible") {
		const generated$1 = generate(jsonSchema, ctx);
		return generated$1;
	}
	const schema_to_use = pick(potential_schemas);
	const generated = generate(schema_to_use, ctx);
	return generated;
};
const generate_unknown = (schema, ctx) => {
	if (ctx.unknown_options.strategy === "fast") return void 0;
	if (ctx.unknown_options.strategy === "json-compatible") {
		const generated$1 = generate(jsonSchema, ctx);
		return generated$1;
	}
	const schema_to_use = pick(potential_schemas);
	const generated = generate(schema_to_use, ctx);
	return generated;
};
const AnyGenerator = {
	schema: zod.z.ZodAny,
	generator: generate_any,
	match: "instanceof"
};
const UnknownGenerator = {
	schema: zod.z.ZodUnknown,
	generator: generate_unknown,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/numbers.ts
const generate_number = (number_schema, ctx) => {
	try {
		let proposed_number = NaN;
		const semantic_generators = {
			age: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 120
			}),
			year: () => __faker_js_faker.faker.number.int({
				min: 1200,
				max: 3e3
			}),
			month: () => __faker_js_faker.faker.number.int({
				min: 1,
				max: 12
			}),
			"day-of-the-month": () => __faker_js_faker.faker.number.int({
				min: 1,
				max: 31
			}),
			hour: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 23
			}),
			minute: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 59
			}),
			second: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 59
			}),
			millisecond: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 999
			}),
			weekday: () => __faker_js_faker.faker.number.int({
				min: 0,
				max: 6
			})
		};
		const generator$6 = semantic_generators[ctx.semantic_context];
		if (!generator$6) throw new Error("No generator found for semantic context - Falling back to random number");
		proposed_number = generator$6();
		return number_schema.parse(proposed_number);
	} catch (e) {}
	let is_extreme_value = weighted_random_boolean(ctx.number_options.extreme_value_chance);
	let is_int = get_number_checks(number_schema, "int").length !== 0;
	let is_finite = get_number_checks(number_schema, "finite").length !== 0;
	let min_checks = get_number_checks(number_schema, "min");
	let max_checks = get_number_checks(number_schema, "max");
	let min_check = min_checks.length === 0 ? null : min_checks.reduce((prev, curr) => prev.value > curr.value ? prev : curr);
	let max_check = max_checks.length === 0 ? null : max_checks.reduce((prev, curr) => prev.value < curr.value ? prev : curr);
	let inclusive_min = min_check?.inclusive ?? true;
	let inclusive_max = max_check?.inclusive ?? true;
	let min = min_check?.value ?? Number.MIN_SAFE_INTEGER / 2;
	let max = max_check?.value ?? Number.MAX_SAFE_INTEGER / 2;
	if (!inclusive_min) {
		const float_step = float_step_size(min);
		min += is_int ? 1 : float_step;
	}
	if (!inclusive_max) {
		const float_step = float_step_size(max);
		max -= is_int ? 1 : float_step;
	}
	if (max < min) throw new InvalidSchemaException("max must be greater than min if specified");
	let value;
	if (is_int) value = __faker_js_faker.faker.number.int({
		min,
		max
	});
	else {
		if (is_extreme_value) {
			const use_lower_extreme = weighted_random_boolean(.5);
			if (use_lower_extreme) value = is_finite ? -Infinity : min;
			else value = is_finite ? Infinity : max;
		}
		value = __faker_js_faker.faker.number.float({
			min,
			max
		});
	}
	if (value === void 0) throw new Error("Failed to generate Number. This is a bug in the built-in generator");
	let multipleof_checks = get_number_checks(number_schema, "multipleOf");
	let multipleof = multipleof_checks.length === 0 ? null : multipleof_checks.reduce((acc, check) => {
		return lcm$1(acc, check.value);
	}, multipleof_checks[0]?.value);
	if (multipleof !== null) {
		let next_higher = value + (multipleof - value % multipleof);
		let next_lower = value - value % multipleof;
		if (next_higher <= max) value = next_higher;
		else if (next_lower >= min) value = next_lower;
		else throw new InvalidSchemaException(`There exists no valid multiple of ${multipleof} between ${min} and ${max}.`);
	}
	return value;
};
function get_number_checks(schema, kind) {
	return schema._def.checks.filter((check) => check.kind === kind);
}
function float_step_size(n) {
	return Math.max(Number.MIN_VALUE, 2 ** Math.floor(Math.log2(n)) * Number.EPSILON);
}
function lcm$1(a, b) {
	return a * b / gcd$1(a, b);
}
function gcd$1(a, b) {
	if (b === 0n || b === 0) return a;
	return gcd$1(b, a % b);
}
const NumberGenerator = {
	schema: zod.z.ZodNumber,
	generator: generate_number,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/tuple.ts
const generate_tuple = (schema, generation_context) => {
	const tuple = schema._def.items.map((item) => generate(item, generation_context));
	return tuple;
};
const TupleGenerator = {
	schema: zod.z.ZodTuple,
	generator: generate_tuple,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/union.ts
const generate_union = (schema, ctx) => {
	const schemas = schema._def.options;
	const possible_indexes = new Array(schemas.length).fill(0).map((_, i) => i);
	const indexes = __faker_js_faker.faker.helpers.shuffle(possible_indexes);
	for (const index of indexes) try {
		ctx.path.push(index);
		const schema$1 = schemas[index];
		return generate(schema$1, ctx);
	} catch (e) {
		if (e instanceof RecursionLimitReachedException) continue;
		else throw e;
	} finally {
		ctx.path.pop();
	}
	throw new RecursionLimitReachedException();
};
const UnionGenerator = {
	schema: zod.z.ZodUnion,
	generator: generate_union,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/semantics.ts
const paragraph_triggers = [
	"about",
	"description",
	"paragraph",
	"text",
	"body",
	"content"
];
const sentence_triggers = [
	"sentence",
	"line",
	"headline",
	"heading"
];
const jobtitle_triggers = [
	"job",
	"title",
	"position",
	"role",
	"occupation",
	"profession",
	"career"
];
const delimiters = [
	",",
	";",
	":",
	"|",
	"/",
	"\\",
	"-",
	"_",
	" "
];
function get_semantic_flag(str) {
	str = str.toLowerCase().trim();
	for (const delimiter of delimiters) str = str.split(delimiter).join(" ");
	if (str.includes("name")) {
		if (str.includes("first")) return "firstname";
		if (str.includes("last")) return "lastname";
		return "fullname";
	}
	if (str.includes("street")) return "street";
	if (str.includes("city")) return "city";
	if (str.includes("country")) return "country";
	if (paragraph_triggers.some((t) => str.includes(t))) return "paragraph";
	if (sentence_triggers.some((t) => str.includes(t))) return "sentence";
	if (str.includes("word")) return "word";
	if (jobtitle_triggers.some((t) => str.includes(t))) return "jobtitle";
	if (str.includes("phone")) return "phoneNumber";
	if (str.includes("age")) return "age";
	if (str.includes("hex")) return "color-hex";
	if (str.includes("color")) return "color";
	if (str.includes("zip")) return "zip";
	if (str.includes("week") && str.includes("day")) return "weekday";
	if (str.includes("birthday")) return "birthday";
	if (str.includes("year")) return "year";
	if (str.includes("month")) return "month";
	if (str.includes("day")) return "day-of-the-month";
	if (str.includes("hour")) return "hour";
	if (str.includes("minute")) return "minute";
	if (str.includes("second")) return "second";
	if (str.includes("millisecond")) return "millisecond";
	if (str.includes("id")) return "unique-id";
	return "unspecified";
}

//#endregion
//#region src/lib/v3/generators/object.ts
const generate_object = (object_schema, ctx) => {
	const mock_entries = [];
	Object.entries(object_schema.shape).forEach((entry) => {
		const key = entry[0];
		const property_schema = entry[1];
		const prev_semantic_context = ctx.semantic_context;
		const semantic_flag = get_semantic_flag(String(key));
		try {
			ctx.path.push(key);
			ctx.semantic_context = semantic_flag;
			const generated_value = generate(property_schema, ctx);
			mock_entries.push([key, generated_value]);
		} finally {
			ctx.path.pop();
			ctx.semantic_context = prev_semantic_context;
		}
	});
	let catchall_schema = object_schema._def.catchall;
	if (catchall_schema instanceof zod.z.ZodNever) catchall_schema = null;
	const is_passthrough = object_schema._def.unknownKeys === "passthrough";
	if (is_passthrough && !catchall_schema) catchall_schema = zod.z.any();
	if (catchall_schema && ctx.object_options.generate_extra_keys) {
		const key_schema = zod.z.union([
			zod.z.string(),
			zod.z.number(),
			zod.z.symbol()
		]);
		const num_additional_keys = __faker_js_faker.faker.number.int({
			min: 0,
			max: 10
		});
		try {
			for (let i = 0; i < num_additional_keys; i++) {
				const prev_semantic_context = ctx.semantic_context;
				let key;
				try {
					ctx.semantic_context = "key";
					key = generate(key_schema, ctx);
				} finally {
					ctx.semantic_context = prev_semantic_context;
				}
				const value = generate(catchall_schema, ctx);
				mock_entries.unshift([key, value]);
			}
		} catch (e) {}
	}
	return Object.fromEntries(mock_entries);
};
const ObjectGenerator = {
	schema: zod.z.ZodObject,
	generator: generate_object,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/set.ts
const generate_set = (schema, ctx) => {
	const size = __faker_js_faker.faker.number.int({
		min: ctx.set_options.min,
		max: ctx.set_options.max
	});
	const set = /* @__PURE__ */ new Set();
	try {
		for (let i = 0; i < size; i++) try {
			ctx.path.push(i);
			const value = generate(schema._def.valueType, ctx);
			set.add(value);
		} finally {
			ctx.path.pop();
		}
	} catch (error) {
		if (error instanceof RecursionLimitReachedException) return set;
		throw error;
	}
	return set;
};
const SetGenerator = {
	schema: zod.z.ZodSet,
	generator: generate_set,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/map.ts
const generate_map = (schema, ctx) => {
	const size = __faker_js_faker.faker.number.int({
		min: ctx.map_options.min,
		max: ctx.map_options.max
	});
	const map = /* @__PURE__ */ new Map();
	try {
		const keys = [];
		for (let i = 0; i < size; i++) {
			const key = generate(schema._def.keyType, ctx);
			keys.push(key);
		}
		for (const key of keys) {
			let prev_semantic_context = ctx.semantic_context;
			try {
				ctx.path.push(key);
				ctx.semantic_context = "key";
				const value = generate(schema._def.valueType, ctx);
				map.set(key, value);
			} finally {
				ctx.path.pop();
				ctx.semantic_context = prev_semantic_context;
			}
		}
	} catch (error) {
		if (error instanceof RecursionLimitReachedException) return map;
		throw error;
	}
	return map;
};
const MapGenerator = {
	schema: zod.z.ZodMap,
	generator: generate_map,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/dates.ts
const generate_date = (date_schema, ctx) => {
	const min = get_date_check(date_schema, "min")?.value ?? null;
	const max = get_date_check(date_schema, "max")?.value ?? null;
	if (min && max && max < min) throw new InvalidSchemaException("max date is less than min date");
	return __faker_js_faker.faker.date.between({
		from: min ?? 0,
		to: max ?? Date.now() + 1e7
	});
};
function get_date_check(schema, kind) {
	const check = schema._def.checks.find((check$1) => check$1.kind === kind);
	return check;
}
const DateGenerator = {
	schema: zod.z.ZodDate,
	generator: generate_date,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/record.ts
const generate_record = (schema, ctx) => {
	const size = __faker_js_faker.faker.number.int({
		min: ctx.record_options.min,
		max: ctx.record_options.max
	});
	const record = {};
	try {
		const keys = [];
		for (let i = 0; i < size; i++) {
			const key = generate(schema._def.keyType, ctx);
			keys.push(key);
		}
		for (const key of keys) {
			let value;
			let prev_semantic_context = ctx.semantic_context;
			try {
				ctx.path.push(key);
				ctx.semantic_context = "key";
				value = generate(schema._def.valueType, ctx);
			} finally {
				ctx.path.pop();
				ctx.semantic_context = prev_semantic_context;
			}
			record[key] = value;
		}
	} catch (error) {
		if (error instanceof RecursionLimitReachedException) return record;
		throw error;
	}
	return record;
};
const RecordGenerator = {
	schema: zod.z.ZodRecord,
	generator: generate_record,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/bigint.ts
const generate_bigint = (bigint_schema, ctx) => {
	const multiple_of_checks = get_bigint_checks(bigint_schema, "multipleOf");
	const min_checks = get_bigint_checks(bigint_schema, "min");
	const max_checks = get_bigint_checks(bigint_schema, "max");
	const min = min_checks.reduce((acc, check) => {
		if (check.value > acc) return check.value;
		return acc;
	}, BigInt(Number.MIN_SAFE_INTEGER));
	const max = max_checks.reduce((acc, check) => {
		if (check.value < acc) return check.value;
		return acc;
	}, BigInt(Number.MAX_SAFE_INTEGER));
	const multipleof = multiple_of_checks.reduce((acc, check) => {
		return lcm(acc, check.value);
	}, 1n);
	let value = __faker_js_faker.faker.number.bigInt({
		min,
		max
	});
	const next_larger_multiple = value + (multipleof - value % multipleof);
	const next_smaller_multiple = value - value % multipleof;
	if (next_larger_multiple <= max) value = next_larger_multiple;
	else if (next_smaller_multiple >= min) value = next_smaller_multiple;
	else throw new InvalidSchemaException("Cannot generate a valid BigInt that satisfies the constraints");
	return value;
};
function get_bigint_checks(schema, kind) {
	return schema._def.checks.filter((check) => check.kind === kind);
}
function lcm(a, b) {
	return a * b / gcd(a, b);
}
function gcd(a, b) {
	if (b === 0n) return a;
	return gcd(b, a % b);
}
const BigintGenerator = {
	schema: zod.z.ZodBigInt,
	generator: generate_bigint,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/promise.ts
const generate_promise = (schema, generation_context) => {
	return generate(schema._def.type, generation_context);
};
const PromiseGenerator = {
	schema: zod.z.ZodPromise,
	generator: generate_promise,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/branded.ts
const generate_branded = (schema, generation_context) => {
	return generate(schema._def.type, generation_context);
};
const BrandedGenerator = {
	schema: zod.z.ZodBranded,
	generator: generate_branded,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/lazy.ts
const generate_lazy = (schema, generation_context) => {
	const getter = schema._def.getter();
	return generate(getter, generation_context);
};
const LazyGenerator = {
	schema: zod.z.ZodLazy,
	generator: generate_lazy,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/symbol.ts
const generate_symbol = () => {
	const symbol_key = __faker_js_faker.faker.string.sample();
	return Symbol.for(symbol_key);
};
const SymbolGenerator = {
	schema: zod.z.ZodSymbol,
	generator: generate_symbol,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/native-enum.ts
const generate_native_enum = (schema, ctx) => {
	const values = Object.values(schema._def.values);
	const value = pick(values);
	return value;
};
const NativeEnumGenerator = {
	schema: zod.z.ZodNativeEnum,
	generator: generate_native_enum,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/enum.ts
const generate_enum = (schema, ctx) => {
	const values = schema._def.values;
	const value = pick(values);
	return value;
};
const EnumGenerator = {
	schema: zod.z.ZodEnum,
	generator: generate_enum,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/boolean.ts
const generate_boolean = () => {
	return __faker_js_faker.faker.datatype.boolean();
};
const BooleanGenerator = {
	schema: zod.z.ZodBoolean,
	generator: generate_boolean,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/discriminated-union.ts
const generate_discriminated_union = (schema, ctx) => {
	const schemas = schema._def.options;
	const possible_indexes = new Array(schemas.length).fill(0).map((_, i) => i);
	const indexes = __faker_js_faker.faker.helpers.shuffle(possible_indexes);
	for (const index of indexes) try {
		ctx.path.push(index);
		const schema$1 = schemas[index];
		return generate(schema$1, ctx);
	} catch (e) {
		if (e instanceof RecursionLimitReachedException) continue;
		else throw e;
	} finally {
		ctx.path.pop();
	}
	throw new RecursionLimitReachedException();
};
const DiscriminatedUnionGenerator = {
	schema: zod.z.ZodDiscriminatedUnion,
	generator: generate_discriminated_union,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/effects.ts
const generate_effects = (effects_schema, generation_options) => {
	if (effects_schema._def.effect.type !== "transform") throw new NoGeneratorException("To use refinements or preprocessors, you must supply a custom generator for your schema when calling `zocker`");
	const argument = generate(effects_schema._def.schema, generation_options);
	const transform_function = effects_schema._def.effect.transform;
	return transform_function(argument, {
		addIssue: () => {},
		path: []
	});
};
const EffectsGenerator = {
	schema: zod.z.ZodEffects,
	generator: generate_effects,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/array.ts
const generate_array = (array_schema, ctx) => {
	const exact_length = array_schema._def.exactLength?.value ?? null;
	const min = array_schema._def.minLength ? array_schema._def.minLength.value : ctx.array_options.min;
	const max = array_schema._def.maxLength ? array_schema._def.maxLength.value : ctx.array_options.max;
	if (min > max) throw new InvalidSchemaException("min length is greater than max length");
	const length = exact_length !== null ? exact_length : __faker_js_faker.faker.number.int({
		min,
		max
	});
	const generated_array = [];
	try {
		for (let i = 0; i < length; i++) {
			let generated_value;
			try {
				ctx.path.push(i);
				generated_value = generate(array_schema.element, ctx);
			} finally {
				ctx.path.pop();
			}
			generated_array.push(generated_value);
		}
		return generated_array;
	} catch (error) {
		if (!(error instanceof RecursionLimitReachedException)) throw error;
		if (min !== 0) throw error;
		if (exact_length !== null && exact_length !== 0) throw error;
		return [];
	}
};
const ArrayGenerator = {
	schema: zod.z.ZodArray,
	generator: generate_array,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/optional.ts
const generator$1 = (schema, ctx) => {
	const should_be_undefined = weighted_random_boolean(ctx.optional_options.undefined_chance);
	try {
		return should_be_undefined ? void 0 : generate(schema._def.innerType, ctx);
	} catch (e) {
		if (e instanceof RecursionLimitReachedException) return void 0;
		else throw e;
	}
};
const OptionalGenerator = {
	schema: zod.z.ZodOptional,
	generator: generator$1,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/nullable.ts
const generator = (schema, ctx) => {
	const should_be_null = weighted_random_boolean(ctx.nullable_options.null_chance);
	try {
		return should_be_null ? null : generate(schema._def.innerType, ctx);
	} catch (e) {
		if (e instanceof RecursionLimitReachedException) return null;
		else throw e;
	}
};
const NullableGenerator = {
	schema: zod.z.ZodNullable,
	generator,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/string/generators.ts
const uuid = (ctx, lc, cc, td) => {
	if (lc.exact && lc.exact !== 36) throw new InvalidSchemaException("uuid length must be exactly 36 if specified");
	if (lc.min && lc.min > 36) throw new InvalidSchemaException("uuid length must be 36");
	if (lc.max && lc.max < 36) throw new InvalidSchemaException("uuid length must be 36");
	return __faker_js_faker.faker.string.uuid();
};
const cuid = (ctx, lc, cc, td) => {
	if (lc.max && lc.max < 9 || lc.exact && lc.exact < 8) throw new InvalidSchemaException("cuid length must be at least 9");
	let min = lc.min && lc.min >= 9 ? lc.min : 9;
	let max = lc.max ? lc.max : 25;
	const regex$1 = /^c[^\s-]{8,}$/i;
	return generate_regex(regex$1);
};
const cuid2 = (ctx, lc, cc, td) => {
	if (lc.exact && lc.exact < 1 || lc.max && lc.max < 1) throw new InvalidSchemaException("cuid2 length must be at least 1");
	let min = lc.min && lc.min >= 1 ? lc.min : 1;
	let max = lc.max ? lc.max : 25;
	const regex$1 = /* @__PURE__ */ new RegExp(`^[a-z][a-z0-9]{${min - 1},${max - 1}}$`);
	return generate_regex(regex$1);
};
const ulid = (ctx, lc, cc, td) => {
	if (lc.exact && lc.exact !== 26) throw new InvalidSchemaException("ulid length must be exactly 26 if specified");
	if (lc.min && lc.min > 26) throw new InvalidSchemaException("ulid length must be 26");
	if (lc.max && lc.max < 26) throw new InvalidSchemaException("ulid length must be 26");
	const regex$1 = /[0-9A-HJKMNP-TV-Z]{26}/;
	return generate_regex(regex$1);
};
const ip = (ctx, lc, cc, td) => {
	const format = cc.format;
	const version = format.version ?? null;
	if (version === "v4") return __faker_js_faker.faker.internet.ipv4();
	if (version === "v6") return __faker_js_faker.faker.internet.ipv6();
	return weighted_random_boolean(.5) ? __faker_js_faker.faker.internet.ipv4() : __faker_js_faker.faker.internet.ipv6();
};
const datetime = (ctx, lc, cc, td) => {
	const format = cc.format;
	const offset = format.offset === true;
	let datetime$1 = __faker_js_faker.faker.date.recent().toISOString();
	if (offset) {
		const hours_number = __faker_js_faker.faker.number.int({
			min: 0,
			max: 23
		});
		const minutes_number = __faker_js_faker.faker.number.int({
			min: 0,
			max: 59
		});
		const hours = hours_number.toString().padStart(2, "0");
		const minutes = minutes_number.toString().padStart(2, "0");
		const sign = weighted_random_boolean(.5) ? "+" : "-";
		datetime$1 = datetime$1.replace("Z", `${sign}${hours}:${minutes}`);
	}
	return datetime$1;
};
const email = (ctx, lc, cc, td) => {
	return __faker_js_faker.faker.internet.email();
};
const url = (ctx, lc, cc, td) => {
	return __faker_js_faker.faker.internet.url();
};
const emoji = (ctx, lc, cc, td) => {
	const length = lc.exact ?? __faker_js_faker.faker.number.int({
		min: lc.min ?? 0,
		max: lc.max ?? (lc.min !== null ? lc.min + 1e4 : 1e4)
	});
	let emojis = "";
	for (let i = 0; i < length; i++) emojis += __faker_js_faker.faker.internet.emoji();
	return emojis;
};
const regex = (ctx, lc, cc, td) => {
	const format = cc.format;
	const regex$1 = new RegExp(format.regex);
	return generate_regex(regex$1);
};
const any = (ctx, lc, cc, td) => {
	try {
		const semantic_generators = {
			fullname: __faker_js_faker.faker.person.fullName,
			firstname: __faker_js_faker.faker.person.firstName,
			lastname: __faker_js_faker.faker.person.lastName,
			street: __faker_js_faker.faker.location.street,
			city: __faker_js_faker.faker.location.city,
			country: __faker_js_faker.faker.location.country,
			zip: __faker_js_faker.faker.location.zipCode,
			phoneNumber: __faker_js_faker.faker.phone.number,
			paragraph: __faker_js_faker.faker.lorem.paragraph,
			sentence: __faker_js_faker.faker.lorem.sentence,
			word: __faker_js_faker.faker.lorem.word,
			jobtitle: __faker_js_faker.faker.person.jobTitle,
			color,
			"color-hex": () => __faker_js_faker.faker.color.rgb({
				prefix: "#",
				casing: "lower"
			}),
			weekday: __faker_js_faker.faker.date.weekday,
			"unique-id": () => __faker_js_faker.faker.string.uuid(),
			key: () => __faker_js_faker.faker.lorem.word(),
			unspecified: () => __faker_js_faker.faker.lorem.paragraphs(__faker_js_faker.faker.number.int({
				min: 1,
				max: 5
			}))
		};
		const generator$6 = semantic_generators[ctx.semantic_context];
		if (!generator$6) throw new Error("No semantic generator found for context - falling back to random string");
		const proposed_string = generator$6();
		if (!matches_constraints(proposed_string, lc, cc)) throw new Error("Invalid string generated, falling back to random string");
		return proposed_string;
	} catch (e) {}
	const min = Math.max(0, lc.min ?? 0, (cc.starts_with?.length ?? 0) + (cc.ends_with?.length ?? 0) + cc.includes.reduce((a, b) => a + b.length, 0));
	const max = lc.max ?? (lc.min !== null ? lc.min + 1e4 : 1e4);
	let length = lc.exact ?? __faker_js_faker.faker.number.int({
		min,
		max
	});
	const generated_length = length - (cc.starts_with?.length ?? 0) - (cc.ends_with?.length ?? 0) - cc.includes.reduce((a, b) => a + b.length, 0);
	if (generated_length < 0) throw new InvalidSchemaException("Length constraints are impossible to satisfy");
	return (cc.starts_with ?? "") + __faker_js_faker.faker.string.sample(generated_length) + cc.includes.join() + (cc.ends_with ?? "");
};
function color() {
	const generators = [__faker_js_faker.faker.color.human, __faker_js_faker.faker.internet.color];
	return pick(generators)();
}
function matches_constraints(str, lc, cc) {
	if (lc.exact && str.length !== lc.exact) return false;
	if (lc.min && str.length < lc.min) return false;
	if (lc.max && str.length > lc.max) return false;
	if (cc.starts_with && !str.startsWith(cc.starts_with)) return false;
	if (cc.ends_with && !str.endsWith(cc.ends_with)) return false;
	if (cc.includes.length > 0 && !cc.includes.every((i) => str.includes(i))) return false;
	return true;
}
function generate_regex(regex$1) {
	const randexp$1 = new randexp.default(regex$1);
	randexp$1.randInt = (min, max) => __faker_js_faker.faker.number.int({
		min,
		max
	});
	return randexp$1.gen();
}

//#endregion
//#region src/lib/v3/generators/string/index.ts
const generate_string = (string_schema, ctx) => {
	const cc = content_constraints(string_schema);
	const lc = length_constraints(string_schema);
	const tf = transforms(string_schema);
	const generate_raw_string = () => {
		switch (cc.format.kind) {
			case "ip": return ip(ctx, lc, cc, tf);
			case "datetime": return datetime(ctx, lc, cc, tf);
			case "email": return email(ctx, lc, cc, tf);
			case "url": return url(ctx, lc, cc, tf);
			case "uuid": return uuid(ctx, lc, cc, tf);
			case "cuid": return cuid(ctx, lc, cc, tf);
			case "cuid2": return cuid2(ctx, lc, cc, tf);
			case "ulid": return ulid(ctx, lc, cc, tf);
			case "emoji": return emoji(ctx, lc, cc, tf);
			case "regex": return regex(ctx, lc, cc, tf);
			case "any":
			default: return any(ctx, lc, cc, tf);
		}
	};
	let string = generate_raw_string();
	if (tf.trim) string = string.trim();
	if (tf.case === "upper") string = string.toUpperCase();
	else if (tf.case === "lower") string = string.toLowerCase();
	return string;
};
function get_string_checks(schema, kind) {
	const check = schema._def.checks.filter((check$1) => check$1.kind === kind);
	return check;
}
/**
* Gets the length constraints from a ZodString schema
* @param schema
* @throws InvalidSchemaException if the schemas length constraints are impossible
*/
function length_constraints(schema) {
	const exact = get_string_checks(schema, "length")[0]?.value ?? null;
	const min_checks = get_string_checks(schema, "min");
	const max_checks = get_string_checks(schema, "max");
	const min = min_checks.length === 0 ? null : min_checks.map((c) => c.value).reduce((a, b) => Math.max(a, b), 0);
	const max = max_checks.length === 0 ? null : max_checks.map((c) => c.value).reduce((a, b) => Math.min(a, b), 1e4);
	if (min !== null && max !== null && min > max) throw new InvalidSchemaException("min length is greater than max length - The Schema cannot be satisfied");
	if (exact !== null) {
		if (min !== null && exact < min) throw new InvalidSchemaException("exact length is less than min length - The Schema cannot be satisfied");
		if (max !== null && exact > max) throw new InvalidSchemaException("exact length is greater than max length - The Schema cannot be satisfied");
	}
	return {
		exact,
		min,
		max
	};
}
function content_constraints(schema) {
	const starts_with_checks = get_string_checks(schema, "startsWith").sort((a, b) => b.value.length - a.value.length);
	const ends_with_checks = get_string_checks(schema, "endsWith").sort((a, b) => b.value.length - a.value.length);
	const starts_with = starts_with_checks[0]?.value ?? null;
	const ends_with = ends_with_checks[0]?.value ?? null;
	if (starts_with_checks.length >= 2) for (let i = 0; i < starts_with_checks.length - 1; i++) {
		const first = starts_with_checks[i].value;
		const second = starts_with_checks[i + 1].value;
		if (!first.startsWith(second)) throw new InvalidSchemaException("startsWith constraints are not compatible - The Schema cannot be satisfied");
	}
	if (ends_with_checks.length >= 2) for (let i = 0; i < ends_with_checks.length - 1; i++) {
		const first = ends_with_checks[i].value;
		const second = ends_with_checks[i + 1].value;
		if (!first.endsWith(second)) throw new InvalidSchemaException("endsWith constraints are not compatible - The Schema cannot be satisfied");
	}
	const include_checks = schema._def.checks.filter((check) => check.kind === "includes");
	let includes = include_checks.map((check) => check.value).sort((a, b) => b.length - a.length);
	if (includes.length >= 2) {}
	if (starts_with !== null) includes = includes.filter((include) => !starts_with.includes(include));
	if (ends_with !== null) includes = includes.filter((include) => !ends_with.includes(include));
	const format_checks = [
		"uuid",
		"email",
		"url",
		"regex",
		"cuid",
		"cuid2",
		"ulid",
		"emoji",
		"ip",
		"datetime"
	];
	const checks_to_formats = {
		uuid: () => ({ kind: "uuid" }),
		email: () => ({ kind: "email" }),
		url: () => ({ kind: "url" }),
		regex: (checks$1) => {
			if (starts_with !== null || ends_with !== null || includes.length > 0) throw new NoGeneratorException("Zocker's included regex generator currently does not work together with `starts_with`, `ends_with` or `includes`. Incorperate these into your regex, or provide a custom generator.");
			if (checks$1.length > 1) throw new NoGeneratorException("Zocker's included regex generator currently does support multiple regex checks on the same string. Provide a custom generator instead.");
			const regex$1 = checks$1[0]?.regex;
			return {
				kind: "regex",
				regex: regex$1
			};
		},
		cuid: () => ({ kind: "cuid" }),
		cuid2: () => ({ kind: "cuid2" }),
		ulid: () => ({ kind: "ulid" }),
		emoji: () => ({ kind: "emoji" }),
		ip: (checks$1) => {
			let version = void 0;
			for (const check of checks$1) {
				if (check.version && version && check.version !== version) throw new InvalidSchemaException("Specified multiple incompatible versions of IP address");
				version = check.version ?? version;
			}
			return {
				kind: "ip",
				version: version ?? null
			};
		},
		datetime: (checks$1) => {
			let offset = true;
			for (const check of checks$1) if (check.offset !== true) offset = false;
			return {
				kind: "datetime",
				offset
			};
		}
	};
	let format_kind = void 0;
	let checks = [];
	for (const check of schema._def.checks) {
		if (!format_checks.includes(check.kind)) continue;
		if (format_kind !== check.kind && format_kind) throw new InvalidSchemaException("Multiple incompatible format constraints - The Schema cannot be satisfied");
		else format_kind = check.kind;
		checks.push(check);
	}
	if (!format_kind) {
		const format$1 = { kind: "any" };
		return {
			format: format$1,
			starts_with,
			ends_with,
			includes
		};
	}
	const format_factory = checks_to_formats[format_kind];
	const format = format_factory ? format_factory(checks) : { kind: "any" };
	return {
		format,
		starts_with,
		ends_with,
		includes
	};
}
function transforms(schema) {
	const transform_definition = {
		trim: false,
		case: null
	};
	const transform_types = [
		"trim",
		"toUpperCase",
		"toLowerCase"
	];
	let transform_seen = false;
	for (const check of schema._def.checks) {
		const is_transform = transform_types.includes(check.kind);
		if (!is_transform && transform_seen) throw new NoGeneratorException("Zocker currently does not support `trim` and `toUpperCase`/`toLowerCase`, unless they are the last checks in the chain");
		transform_seen = transform_seen || is_transform;
		if (is_transform) switch (check.kind) {
			case "trim":
				transform_definition.trim = true;
				break;
			case "toUpperCase":
				transform_definition.case = "upper";
				break;
			case "toLowerCase":
				transform_definition.case = "lower";
				break;
		}
	}
	return transform_definition;
}
const StringGenerator = {
	schema: zod.z.ZodString,
	generator: generate_string,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/intersection/index.ts
const generate_intersection = (schema, ctx) => {
	const schema_1 = schema._def.left;
	const schema_2 = schema._def.right;
	const merged = merge_schema(schema_1, schema_2);
	return generate(merged, ctx);
};
const merge_schema = (schema_1, schema_2) => {
	if (schema_1 instanceof zod.z.ZodNumber && schema_2 instanceof zod.z.ZodNumber) {
		const combined = zod.z.number();
		combined._def.checks = [...schema_1._def.checks, ...schema_2._def.checks];
		return combined;
	}
	if (schema_1 instanceof zod.z.ZodString && schema_2 instanceof zod.z.ZodString) {
		const combined = zod.z.string();
		combined._def.checks = [...schema_1._def.checks, ...schema_2._def.checks];
		return combined;
	}
	if (schema_1 instanceof zod.z.ZodBoolean && schema_2 instanceof zod.z.ZodBoolean) return zod.z.boolean();
	if (schema_1 instanceof zod.z.ZodLiteral && schema_2 instanceof zod.z.ZodLiteral) if (schema_1._def.value === schema_2._def.value) return schema_1;
	else throw new InvalidSchemaException("There is no intersection between two literals with different values.");
	if (schema_1 instanceof zod.z.ZodSymbol && schema_2 instanceof zod.z.ZodSymbol) return zod.z.symbol();
	throw new NoGeneratorException("ZodIntersections only have very limited support at the moment.");
};
const IntersectionGenerator = {
	schema: zod.z.ZodIntersection,
	generator: generate_intersection,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/generators/readonly.ts
const generate_readonly = (readonly_schema, ctx) => {
	const inner = generate(readonly_schema._def.innerType, ctx);
	if (typeof inner === "object") Object.freeze(inner);
	return inner;
};
const ReadonlyGenerator = {
	schema: zod.z.ZodReadonly,
	generator: generate_readonly,
	match: "instanceof"
};

//#endregion
//#region src/lib/v3/default_generators.ts
const default_generators = [
	StringGenerator,
	NumberGenerator,
	BigintGenerator,
	BooleanGenerator,
	DateGenerator,
	SymbolGenerator,
	OptionalGenerator,
	NullableGenerator,
	AnyGenerator,
	UnknownGenerator,
	EffectsGenerator,
	ArrayGenerator,
	TupleGenerator,
	RecordGenerator,
	MapGenerator,
	SetGenerator,
	ObjectGenerator,
	UnionGenerator,
	NativeEnumGenerator,
	EnumGenerator,
	DefaultGenerator,
	DiscriminatedUnionGenerator,
	PromiseGenerator,
	LazyGenerator,
	BrandedGenerator,
	ReadonlyGenerator,
	{
		schema: zod.z.ZodVoid,
		generator: () => {},
		match: "instanceof"
	},
	{
		schema: zod.z.ZodUndefined,
		generator: () => void 0,
		match: "instanceof"
	},
	{
		schema: zod.z.ZodNull,
		generator: () => null,
		match: "instanceof"
	},
	{
		schema: zod.z.ZodNaN,
		generator: () => NaN,
		match: "instanceof"
	},
	{
		schema: zod.z.ZodLiteral,
		generator: (schema) => schema._def.value,
		match: "instanceof"
	},
	IntersectionGenerator
];

//#endregion
//#region src/lib/v3/zocker.ts
function zocker$2(schema) {
	return new Zocker(schema);
}
var Zocker = class {
	instanceof_generators = [...default_generators];
	reference_generators = [];
	seed = void 0;
	recursion_limit = 5;
	number_options = { extreme_value_chance: .3 };
	optional_options = { undefined_chance: .3 };
	nullable_options = { null_chance: .3 };
	default_options = { default_chance: .3 };
	map_options = {
		max: 10,
		min: 0
	};
	record_options = {
		max: 10,
		min: 0
	};
	set_options = {
		max: 10,
		min: 0
	};
	any_options = { strategy: "true-any" };
	unknown_options = { strategy: "true-any" };
	array_options = {
		min: 0,
		max: 10
	};
	object_options = { generate_extra_keys: true };
	constructor(schema) {
		this.schema = schema;
	}
	/**
	* Supply your own value / function for generating values for a given schema
	* It will be used whenever the given schema matches an encountered schema by referebce
	*
	* @param schema - The schema for which this value will be used
	* @param generator - A value, or a function that generates a value that matches the schema
	*/
	supply(schema, generator$6) {
		const next = this.clone();
		const generator_function = typeof generator$6 === "function" ? generator$6 : () => generator$6;
		next.reference_generators = [{
			schema,
			generator: generator_function,
			match: "reference"
		}, ...next.reference_generators];
		return next;
	}
	/**
	* Override one of the built-in generators using your own.
	* It will be used whenever an encoutntered Schema matches the one specified by **instance**
	*
	* @param schema - Which schema to override. E.g: `z.ZodNumber`.
	* @param generator - A value, or a function that generates a value that matches the schema
	*/
	override(schema, generator$6) {
		const next = this.clone();
		const generator_function = typeof generator$6 === "function" ? generator$6 : () => generator$6;
		const resolved_schema = typeof schema !== "string" ? schema : OVERRIDE_NAMES[schema];
		next.instanceof_generators = [{
			schema: resolved_schema,
			generator: generator_function,
			match: "instanceof"
		}, ...next.instanceof_generators];
		return next;
	}
	setSeed(seed) {
		const next = this.clone();
		next.seed = seed;
		return next;
	}
	setDepthLimit(limit) {
		const next = this.clone();
		next.recursion_limit = limit;
		return next;
	}
	number(options) {
		const next = this.clone();
		next.number_options = {
			...next.number_options,
			...options
		};
		return next;
	}
	optional(options) {
		const next = this.clone();
		next.optional_options = {
			...next.optional_options,
			...options
		};
		return next;
	}
	nullable(options) {
		const next = this.clone();
		next.nullable_options = {
			...next.nullable_options,
			...options
		};
		return next;
	}
	default(options) {
		const next = this.clone();
		next.default_options = {
			...next.default_options,
			...options
		};
		return next;
	}
	map(options) {
		const next = this.clone();
		next.map_options = {
			...next.map_options,
			...options
		};
		return next;
	}
	record(options) {
		const next = this.clone();
		next.record_options = {
			...next.record_options,
			...options
		};
		return next;
	}
	set(options) {
		const next = this.clone();
		next.set_options = {
			...next.set_options,
			...options
		};
		return next;
	}
	any(options) {
		const next = this.clone();
		next.any_options = {
			...next.any_options,
			...options
		};
		return next;
	}
	unknown(options) {
		const next = this.clone();
		next.unknown_options = {
			...next.unknown_options,
			...options
		};
		return next;
	}
	array(options) {
		const next = this.clone();
		next.array_options = {
			...next.array_options,
			...options
		};
		return next;
	}
	object(options) {
		const next = this.clone();
		next.object_options = {
			...next.object_options,
			...options
		};
		return next;
	}
	generate() {
		const ctx = {
			reference_generators: this.reference_generators,
			instanceof_generators: this.instanceof_generators,
			recursion_limit: this.recursion_limit,
			path: [],
			semantic_context: "unspecified",
			parent_schemas: /* @__PURE__ */ new Map(),
			seed: this.seed ?? Math.random() * 1e7,
			number_options: this.number_options,
			optional_options: this.optional_options,
			nullable_options: this.nullable_options,
			default_options: this.default_options,
			map_options: this.map_options,
			record_options: this.record_options,
			set_options: this.set_options,
			any_options: this.any_options,
			unknown_options: this.unknown_options,
			array_options: this.array_options,
			object_options: this.object_options
		};
		__faker_js_faker.faker.seed(ctx.seed);
		return generate(this.schema, ctx);
	}
	generateMany(count) {
		let previous_seed = this.seed;
		const results = [];
		for (let i = 0; i < count; i++) {
			if (previous_seed !== void 0) this.seed = previous_seed + i;
			results.push(this.generate());
		}
		this.seed = previous_seed;
		return results;
	}
	clone() {
		return Object.create(Object.getPrototypeOf(this), Object.getOwnPropertyDescriptors(this));
	}
};
const OVERRIDE_NAMES = {
	number: zod.z.ZodNumber,
	string: zod.z.ZodString,
	boolean: zod.z.ZodBoolean,
	bigint: zod.z.ZodBigInt,
	date: zod.z.ZodDate,
	undefined: zod.z.ZodUndefined,
	null: zod.z.ZodNull,
	any: zod.z.ZodAny,
	unknown: zod.z.ZodUnknown,
	void: zod.z.ZodVoid,
	never: zod.z.ZodNever,
	array: zod.z.ZodArray,
	object: zod.z.ZodObject,
	union: zod.z.ZodUnion,
	intersection: zod.z.ZodIntersection,
	tuple: zod.z.ZodTuple,
	record: zod.z.ZodRecord,
	map: zod.z.ZodMap,
	set: zod.z.ZodSet,
	lazy: zod.z.ZodLazy,
	literal: zod.z.ZodLiteral,
	enum: zod.z.ZodEnum,
	nativeEnum: zod.z.ZodNativeEnum,
	promise: zod.z.ZodPromise,
	transformer: zod.z.ZodTransformer,
	optional: zod.z.ZodOptional,
	nullable: zod.z.ZodNullable,
	effects: zod.z.ZodEffects
};

//#endregion
//#region src/index.ts
function zocker(schema) {
	if ("_zod" in schema) return zocker$1(schema);
	else return zocker$2(schema);
}

//#endregion
exports.zocker = zocker;