import * as yup from 'yup';
export declare const facilitySettings: {
    name: string;
    description: string;
    properties: {
        appointments: {
            description: string;
            properties: {
                bookingSlots: {
                    description: string;
                    properties: {
                        startTime: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        endTime: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        slotDuration: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        certifications: {
            properties: {
                covidClearanceCertificate: {
                    properties: {
                        after: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        daysSinceSampleTime: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                        labTestCategories: {
                            description: string;
                            type: yup.ArraySchema<string[], yup.AnyObject, "", "">;
                            defaultValue: any[];
                        };
                        labTestTypes: {
                            description: string;
                            type: yup.ArraySchema<string[], yup.AnyObject, "", "">;
                            defaultValue: any[];
                        };
                        labTestResults: {
                            description: string;
                            type: yup.ArraySchema<string[], yup.AnyObject, "", "">;
                            defaultValue: string[];
                        };
                    };
                };
            };
        };
        questionCodeIds: {
            deprecated: boolean;
            description: string;
            properties: {
                passport: {
                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                    defaultValue: string;
                };
                nationalityId: {
                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                    defaultValue: string;
                };
                email: {
                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                    defaultValue: any;
                };
            };
        };
        sync: {
            description: string;
            highRisk: boolean;
            properties: {
                syncAllLabRequests: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                urgentIntervalInSeconds: {
                    name: string;
                    unit: string;
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                };
            };
        };
        vaccinations: {
            name: string;
            description: string;
            properties: {
                defaults: {
                    description: string;
                    properties: {
                        locationGroupId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: any;
                        };
                        locationId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: any;
                        };
                        departmentId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: any;
                        };
                    };
                };
                givenElsewhere: {
                    properties: {
                        defaults: {
                            properties: {
                                locationGroupId: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                                    defaultValue: any;
                                };
                                locationId: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                                    defaultValue: any;
                                };
                                departmentId: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                                    defaultValue: any;
                                };
                            };
                        };
                    };
                };
            };
        };
        medications: {
            name: string;
            description: string;
            properties: {
                medicationDispensing: {
                    name: string;
                    description: string;
                    properties: {
                        automaticEncounterLocationId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: any;
                            suggesterEndpoint: string;
                        };
                        automaticEncounterDepartmentId: {
                            name: string;
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: any;
                            suggesterEndpoint: string;
                        };
                    };
                };
            };
        };
        survey: {
            name: string;
            description: string;
            properties: {
                defaultCodes: {
                    description: string;
                    properties: {
                        department: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        location: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        templates: {
            description: string;
            properties: {
                letterhead: {
                    description: string;
                    properties: {
                        title: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        subTitle: {
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
    };
};
export declare const facilityDefaults: any;
