"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PrescriptionPrintout", {
    enumerable: true,
    get: function() {
        return PrescriptionPrintout;
    }
});
const _renderer = require("@react-pdf/renderer");
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _constants = require("@tamanu/constants");
const _Layout = require("./Layout");
const _PatientDetailsWithBarcode = require("./printComponents/PatientDetailsWithBarcode");
const _Table = require("./Table");
const _DataSection = require("./printComponents/DataSection");
const _DataItem = require("./printComponents/DataItem");
const _getDisplayDate = require("./getDisplayDate");
const _dateTime = require("@tamanu/utils/dateTime");
const _LetterheadSection = require("./LetterheadSection");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _medication = require("../medication");
const _Footer = require("./printComponents/Footer");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const columns = (getTranslation, getEnumTranslation)=>[
        {
            key: 'medication',
            title: getTranslation('pdf.table.column.medication', 'Medication'),
            accessor: ({ medication, notes, indication })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_renderer.Text, null, medication?.name + `\n`), notes && /*#__PURE__*/ _react.default.createElement(_renderer.Text, {
                    style: {
                        fontFamily: 'Helvetica-Oblique'
                    }
                }, notes + `\n`), indication && /*#__PURE__*/ _react.default.createElement(_renderer.Text, null, /*#__PURE__*/ _react.default.createElement(_renderer.Text, {
                    style: {
                        fontFamily: 'Helvetica-Bold'
                    }
                }, getTranslation('medication.indication.label', 'Indication'), ":"), /*#__PURE__*/ _react.default.createElement(_renderer.Text, null, ` ${indication}`))),
            customStyles: {
                minWidth: 180
            }
        },
        {
            key: 'dose',
            title: getTranslation('pdf.table.column.dose', 'Dose'),
            accessor: (medication)=>{
                return /*#__PURE__*/ _react.default.createElement(_renderer.Text, null, (0, _medication.getMedicationDoseDisplay)(medication, getTranslation, getEnumTranslation), medication?.isPrn && ` ${getTranslation('medication.table.prn', 'PRN')}`);
            }
        },
        {
            key: 'frequency',
            title: getTranslation('pdf.table.column.frequency', 'Frequency'),
            accessor: ({ frequency })=>(0, _medication.getTranslatedFrequency)(frequency, getTranslation),
            customStyles: {
                minWidth: 30
            }
        },
        {
            key: 'route',
            title: getTranslation('pdf.table.column.route', 'Route'),
            accessor: ({ route })=>getEnumTranslation(_constants.DRUG_ROUTE_LABELS, route)
        },
        {
            key: 'quantity',
            title: getTranslation('pdf.table.column.quantity', 'Quantity'),
            accessor: ({ quantity })=>quantity
        },
        {
            key: 'repeats',
            title: getTranslation('pdf.table.column.repeats', 'Repeats'),
            accessor: ({ repeats })=>repeats
        }
    ];
const prescriptionSectionStyles = _renderer.StyleSheet.create({
    tableContainer: {
        marginTop: 12
    }
});
const signingSectionStyles = _renderer.StyleSheet.create({
    container: {
        marginTop: 22
    }
});
const generalStyles = _renderer.StyleSheet.create({
    container: {
        marginVertical: 8
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.container,
        ...props
    });
const PrescriptionsSection = ({ prescriptions, prescriber, facility, getLocalisation, getSetting })=>{
    const { getTranslation, getEnumTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        hideBottomRule: true,
        title: "Prescription details"
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Date",
        value: (0, _getDisplayDate.getDisplayDate)((0, _dateTime.getCurrentDateString)())
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Prescriber",
        value: prescriber?.displayName
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Prescriber ID",
        value: prescriber?.displayId ?? 'n/a'
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Facility",
        value: facility?.name
    }))), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: prescriptionSectionStyles.tableContainer
    }, /*#__PURE__*/ _react.default.createElement(_Table.Table, {
        columns: columns(getTranslation, getEnumTranslation),
        data: prescriptions,
        getLocalisation: getLocalisation,
        getSetting: getSetting,
        columnStyle: {
            padding: '8px 7px'
        }
    })));
};
const PrescriptionSigningSection = ()=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signingSectionStyles.container
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
        fontSize: 9,
        lineThickness: 0.5,
        text: "Signed"
    }), /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
        fontSize: 9,
        lineThickness: 0.5,
        text: "Date"
    }));
const PrescriptionPrintoutComponent = ({ patientData, prescriptions, prescriber, certificateData, facility, getLocalisation, getSetting })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: [
            _Layout.styles.page,
            {
                paddingBottom: '50'
            }
        ]
    }, /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        letterheadConfig: certificateData,
        logoSrc: certificateData.logo,
        certificateTitle: "Prescription"
    }), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_PatientDetailsWithBarcode.PatientDetailsWithBarcode, {
        patient: patientData,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    }))), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateContent, {
        style: {
            margin: 0
        }
    }, /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(PrescriptionsSection, {
        prescriptions: prescriptions,
        prescriber: prescriber,
        facility: facility,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(PrescriptionSigningSection, null))), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, {
        style: {
            left: 30,
            right: 30
        }
    })));
};
const PrescriptionPrintout = (0, _languageContext.withLanguageContext)(PrescriptionPrintoutComponent);

//# sourceMappingURL=PrescriptionPrintout.js.map