import { z } from 'zod';
export declare const PortalSurveyAssignmentSchema: z.ZodObject<{
    id: z.ZodString;
    survey: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        surveyType: z.ZodEnum<{
            PROGRAMS: string;
            REFERRAL: string;
            OBSOLETE: string;
            VITALS: string;
            SIMPLE_CHART: string;
            COMPLEX_CHART: string;
            COMPLEX_CHART_CORE: string;
        }>;
    }, z.core.$strip>;
    status: z.ZodEnum<{
        OUTSTANDING: string;
        COMPLETED: string;
        CANCELLED: string;
    }>;
    assignedBy: z.ZodObject<{
        id: z.ZodString;
        displayName: z.ZodString;
    }, z.core.$strip>;
    facilityId: z.ZodString;
}, z.core.$strip>;
export type PortalSurveyAssignment = z.infer<typeof PortalSurveyAssignmentSchema>;
//# sourceMappingURL=portalSurveyAssignment.schema.d.ts.map