import React from 'react';
import { LAB_REQUEST_STATUS_LABELS } from '@tamanu/constants';
import { Col, Row } from './Layout';
import { P } from './Typography';
import { DataItem } from './printComponents/DataItem';
import { PrintableBarcode } from './printComponents/PrintableBarcode';
import { getDisplayDate } from './getDisplayDate';
import { useLanguageContext } from '../pdf/languageContext';
const DATE_TIME_FORMAT = 'dd/MM/yyyy h:mma';
export const SampleDetailsRow = ({ request })=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.sampleDateTime.label', 'Sample date & time'),
        value: getDisplayDate(request.sampleTime, DATE_TIME_FORMAT)
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.collectedBy.label', 'Collected by'),
        value: request.collectedBy?.displayName
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.site.label', 'Site'),
        value: request.site?.name
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.specimenType.label', 'Specimen type'),
        value: request.specimenType?.name
    })));
};
export const PublishedDetailsRow = ({ request })=>{
    const { getEnumTranslation, getTranslation } = useLanguageContext();
    const notApplicable = getTranslation('general.fallback.notApplicable', 'N/A', {
        casing: 'lower'
    });
    return /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.publishedDate.label', 'Published date & time'),
        value: request.publishedDate ? getDisplayDate(request.publishedDate, DATE_TIME_FORMAT) : notApplicable
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.publishedBy.label', 'Published by'),
        value: request.publishedBy?.displayName ?? notApplicable
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.status.label', 'Status'),
        value: getEnumTranslation(LAB_REQUEST_STATUS_LABELS, request.status)
    })));
};
export const MinimalLabRequestDetailsSection = ({ request })=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.requestId.label', 'Request ID'),
        value: request.displayId
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.requestedBy.label', 'Requested by'),
        value: request.requestedBy?.displayName
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.requestedDate.label', 'Requested date & time'),
        value: getDisplayDate(request.requestedDate, DATE_TIME_FORMAT)
    })));
};
export const FullLabRequestDetailsSection = ({ request })=>{
    const { getTranslation } = useLanguageContext();
    const labTestTypeAccessor = ({ labTestPanelRequest, tests })=>{
        if (labTestPanelRequest) {
            return labTestPanelRequest.labTestPanel.name;
        }
        return tests?.map((test)=>test.labTestType?.name).join(', ') || '';
    };
    const notesAccessor = ({ notes })=>{
        return notes?.map((note)=>note?.content || '').filter(Boolean).join(',\n') || '';
    };
    return /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.requestId.label', 'Request ID'),
        value: request.displayId
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.requestedBy.label', 'Requested by'),
        value: request.requestedBy?.displayName
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.priority.label', 'Priority'),
        value: request.priority?.name
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.requestedDate.label', 'Requested date & time'),
        value: getDisplayDate(request.requestedDate, DATE_TIME_FORMAT)
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.testCategory.label', 'Test category'),
        value: request.category?.name
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('lab.tests.label', 'Tests'),
        value: labTestTypeAccessor(request)
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(P, {
        mt: 9,
        fontSize: 9,
        bold: true
    }, getTranslation('lab.requestIdBarcode.label', 'Request ID barcode:')), /*#__PURE__*/ React.createElement(PrintableBarcode, {
        id: request.displayId
    })))), /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.notes.label', 'Notes'),
        value: notesAccessor(request)
    })));
};

//# sourceMappingURL=LabRequestDetailsSection.js.map