"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    configString: function() {
        return configString;
    },
    jsonString: function() {
        return jsonString;
    },
    jsonStringShape: function() {
        return jsonStringShape;
    },
    validationString: function() {
        return validationString;
    },
    visualisationConfigString: function() {
        return visualisationConfigString;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const jsonString = ()=>_yup.string().test('is-json', // The template curly two lines down is valid in a yup message
    // eslint-disable-next-line no-template-curly-in-string
    '${path} is not valid JSON - consider using an online JSON validator', (value)=>{
        if (!value) return true;
        try {
            JSON.parse(value);
            return true;
        } catch (e) {
            return false;
        }
    });
const jsonStringShape = (name, objectShape)=>_yup.string().test('json-shape', async (value, ctx)=>{
        let parsedObject = null;
        try {
            parsedObject = JSON.parse(value || '{}');
            // Will throw a validation error if shape doesn't match
            const validationResult = await objectShape.validate(parsedObject, {
                strict: true,
                context: ctx.options.context
            });
            return validationResult;
        } catch (e) {
            const errors = e.errors || [
                e.message
            ];
            return new _yup.ValidationError(errors.map((err)=>`${name}: ${err}`));
        }
    });
const configString = (objectShape)=>jsonStringShape('config', objectShape);
const validationString = (objectShape)=>jsonStringShape('validationCriteria', objectShape);
const visualisationConfigString = (objectShape)=>jsonStringShape('visualisationConfig', objectShape);

//# sourceMappingURL=jsonString.js.map