"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "VRSPatientAdapter", {
    enumerable: true,
    get: function() {
        return VRSPatientAdapter;
    }
});
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let VRSPatientAdapter = class VRSPatientAdapter {
    async toTamanu(vrsPatient) {
        const { id_type: idType, identifier, individual_refno: displayId, fname: firstName, lname: lastName, dob: dateOfBirth, sex, sub_division: villageName, phone: primaryContactNumber, email } = vrsPatient;
        // look up village by name
        const { ReferenceData } = this.store.models;
        let villageId;
        if (villageName) {
            const village = await ReferenceData.findOne({
                where: {
                    name: villageName,
                    type: _constants.REFERENCE_TYPES.VILLAGE
                }
            });
            if (village) {
                villageId = village.id;
            } else {
                // villageName will be persisted in a PatientVRSData record
                _logging.log.warn(`VRSPatientAdapter.toTamanu: received sub_division with no village mapping (${villageName})`);
            }
        }
        return {
            patient: {
                displayId,
                firstName,
                lastName,
                dateOfBirth,
                sex,
                villageId,
                email
            },
            patientAdditionalData: {
                primaryContactNumber
            },
            patientVRSData: {
                idType,
                identifier,
                unmatchedVillageName: villageId ? null : villageName
            }
        };
    }
    constructor(store){
        _define_property(this, "store", null);
        this.store = store;
    }
};

//# sourceMappingURL=VRSPatientAdapter.js.map