"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const _fake = require("@tamanu/fake-data/fake");
const _constants = require("../constants");
const _default = {
    run: async (store)=>{
        const { Facility, Department, LocationGroup, Location } = store.models;
        const facDepLoc = [];
        for(let i = 0; i < _constants.NUM_FACILITIES; i++){
            const [facility] = await Facility.upsert({
                ...(0, _fake.fake)(Facility),
                id: `${_constants.REF_ID_PREFIX}-facility-${i}`
            }, {
                returning: true
            });
            const [department] = await Department.upsert({
                ...(0, _fake.fake)(Department),
                id: `${_constants.REF_ID_PREFIX}-department-${i}`,
                facilityId: facility.id
            }, {
                returning: true
            });
            const [locationGroup] = await LocationGroup.upsert((0, _fake.fake)(LocationGroup, {
                id: `${_constants.REF_ID_PREFIX}-locationGroup-${i}`,
                facilityId: facility.id
            }), {
                returning: true
            });
            const [location] = await Location.upsert((0, _fake.fake)(Location, {
                id: `${_constants.REF_ID_PREFIX}-location-${i}`,
                facilityId: facility.id,
                locationGroupId: locationGroup.id
            }), {
                returning: true
            });
            facDepLoc.push([
                facility,
                department,
                location
            ]);
        }
        return facDepLoc;
    }
};

//# sourceMappingURL=facilitiesDepartmentsAndLocations.js.map