"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "AppointmentTypeReferenceData", {
    enumerable: true,
    get: function() {
        return AppointmentTypeReferenceData;
    }
});
const _dataMigrations = require("@tamanu/database/dataMigrations");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let AppointmentTypeReferenceData = class AppointmentTypeReferenceData extends _dataMigrations.CursorDataMigration {
    async getQuery() {
        return `
      with updated as (
      update appointments
      set appointment_type_id = case type_legacy
       when 'Standard' then 'appointmentType-standard'
       when 'Emergency' then 'appointmentType-emergency'
       when 'Specialist' then 'appointmentType-specialist'
       when 'Other' then 'appointmentType-other'
      end
      where id in (
          select id
          from appointments
          where id > $fromId and type_legacy in ('Standard', 'Emergency', 'Specialist', 'Other')
          order by id
          limit $limit
      )
      returning id
      )
      select
        max(id::text) as "maxId",
        count(id) as "count"
      from updated;
    `;
    }
    constructor(...args){
        super(...args), _define_property(this, "lastMaxId", '');
    }
};
_define_property(AppointmentTypeReferenceData, "defaultBatchSize", Number.MAX_SAFE_INTEGER);
_define_property(AppointmentTypeReferenceData, "defaultDelayMs", 50);

//# sourceMappingURL=AppointmentTypeReferenceData.js.map