"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PharmacyOrder", {
    enumerable: true,
    get: function() {
        return PharmacyOrder;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _model = require("../types/model");
const _sync = require("../sync");
let PharmacyOrder = class PharmacyOrder extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            comments: _sequelize.DataTypes.TEXT,
            isDischargePrescription: _sequelize.DataTypes.BOOLEAN,
            date: (0, _model.dateTimeType)('date', {
                allowNull: false
            }),
            facilityId: _sequelize.DataTypes.STRING
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'orderingClinicianId',
            as: 'orderingClinician'
        });
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
        this.hasMany(models.PharmacyOrderPrescription, {
            foreignKey: 'pharmacyOrderId',
            as: 'pharmacyOrderPrescriptions'
        });
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId',
            as: 'facility'
        });
    }
    static getListReferenceAssociations() {
        return [
            'orderingClinician',
            'encounter'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _sync.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return (0, _sync.buildEncounterLinkedLookupFilter)(this);
    }
};

//# sourceMappingURL=PharmacyOrder.js.map