"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createPatientSchema: function() {
        return createPatientSchema;
    },
    updatePatientSchema: function() {
        return updatePatientSchema;
    }
});
const _zod = require("zod");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const _types = require("@tamanu/shared/schemas/types");
const createPatientSchema = _zod.z.object({
    // Required fields for patient creation
    patientRegistryType: _zod.z.enum(_constants.PATIENT_REGISTRY_TYPES),
    facilityId: _types.foreignKey,
    // Primary Details (from GenericPrimaryDetailsLayout)
    displayId: _zod.z.string().max(255).optional(),
    firstName: _zod.z.string().max(255).optional(),
    middleName: _zod.z.string().max(255).optional(),
    lastName: _zod.z.string().max(255).optional(),
    culturalName: _zod.z.string().max(255).optional(),
    email: _zod.z.email().max(255).optional(),
    dateOfBirth: _dateTime.datetimeCustomValidation.optional(),
    sex: _zod.z.enum(_constants.SEX_VALUES),
    villageId: _types.foreignKey.optional(),
    // Identification Information (from GenericIdentificationFields)
    birthCertificate: _types.stringWithMaxLength.optional(),
    drivingLicense: _types.stringWithMaxLength.optional(),
    passport: _types.stringWithMaxLength.optional(),
    // TODO: add max length to insurerId
    insurerId: _types.foreignKey.optional(),
    insurerPolicyNumber: _types.stringWithMaxLength.optional(),
    // Contact Information (from GenericContactFields)
    // Contact numbers are handled as numbers with string coercion to match frontend validation
    primaryContactNumber: _zod.z.coerce.number().optional(),
    secondaryContactNumber: _zod.z.coerce.number().optional(),
    emergencyContactName: _types.stringWithMaxLength.optional(),
    emergencyContactNumber: _zod.z.coerce.number().optional(),
    // Personal Information (from GenericPersonalFields)
    title: _zod.z.enum(_constants.TITLES).optional(),
    maritalStatus: _zod.z.enum(_constants.MARTIAL_STATUS_VALUES).optional(),
    bloodType: _zod.z.enum(_constants.BLOOD_TYPES).optional(),
    placeOfBirth: _types.stringWithMaxLength.optional(),
    countryOfBirthId: _types.foreignKey.optional(),
    nationalityId: _types.foreignKey.optional(),
    ethnicityId: _types.foreignKey.optional(),
    religionId: _types.foreignKey.optional(),
    educationalLevel: _zod.z.enum(_constants.EDUCATIONAL_ATTAINMENT_TYPES).optional(),
    occupationId: _types.foreignKey.optional(),
    socialMedia: _zod.z.enum(_constants.SOCIAL_MEDIA_TYPES).optional(),
    patientBillingTypeId: _types.foreignKey.optional(),
    motherId: _types.foreignKey.optional(),
    fatherId: _types.foreignKey.optional(),
    // Location Information (from GenericLocationFields)
    cityTown: _types.stringWithMaxLength.optional(),
    streetVillage: _types.stringWithMaxLength.optional(),
    countryId: _types.foreignKey.optional(),
    divisionId: _types.foreignKey.optional(),
    subdivisionId: _types.foreignKey.optional(),
    settlementId: _types.foreignKey.optional(),
    medicalAreaId: _types.foreignKey.optional(),
    nursingZoneId: _types.foreignKey.optional(),
    // Birth Details (from GenericBirthFields - only when patientRegistryType is 'birth_registry')
    timeOfBirth: _dateTime.datetimeCustomValidation.optional(),
    gestationalAgeEstimate: _zod.z.number().min(1).max(45).optional(),
    registeredBirthPlace: _zod.z.enum(_constants.PLACE_OF_BIRTH_TYPES).optional(),
    birthFacilityId: _types.foreignKey.optional(),
    attendantAtBirth: _zod.z.enum(_constants.ATTENDANT_OF_BIRTH_TYPES).optional(),
    nameOfAttendantAtBirth: _types.stringWithMaxLength.optional(),
    birthDeliveryType: _zod.z.enum(_constants.BIRTH_DELIVERY_TYPES).optional(),
    birthType: _zod.z.enum(_constants.BIRTH_TYPES).optional(),
    birthWeight: _zod.z.number().min(0).max(6).optional(),
    birthLength: _zod.z.number().min(0).max(100).optional(),
    apgarScoreOneMinute: _zod.z.number().int().min(1).max(10).optional(),
    apgarScoreFiveMinutes: _zod.z.number().int().min(1).max(10).optional(),
    apgarScoreTenMinutes: _zod.z.number().int().min(1).max(10).optional(),
    // Custom patient fields (dynamic field definitions)
    patientFields: _zod.z.record(_zod.z.string(), _zod.z.string()).optional(),
    // Backend-added fields (not from frontend form)
    registeredById: _types.foreignKey
});
const updatePatientSchema = createPatientSchema.partial().omit({
    patientRegistryType: true
});

//# sourceMappingURL=createPatient.schema.js.map