<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function arg

Compute the argument of a complex value.
For a complex number `a + bi`, the argument is computed as `atan2(b, a)`.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.arg(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix |  A complex number or array with complex numbers

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Array &#124; Matrix | The argument of x


## Examples

```js
const a = math.complex(2, 2)
math.arg(a) / math.pi          // returns number 0.25

const b = math.complex('2 + 3i')
math.arg(b)                    // returns number 0.982793723247329
math.atan2(3, 2)               // returns number 0.982793723247329
```


## See also

[re](re.md),
[im](im.md),
[conj](conj.md),
[abs](abs.md)
