"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('lab_requests', 'specimen_type_id', {
        type: _sequelize.DataTypes.STRING,
        references: {
            model: 'reference_data',
            key: 'id'
        },
        allowNull: true
    });
    await query.addColumn('lab_requests', 'collected_by_id', {
        type: _sequelize.DataTypes.STRING,
        references: {
            model: 'users',
            key: 'id'
        },
        allowNull: true
    });
}
async function down(query) {
    await query.removeColumn('lab_requests', 'specimen_type_id');
    await query.removeColumn('lab_requests', 'collected_by_id');
}

//# sourceMappingURL=1683172236844-addSpecimenTypeAndCollectedByToLabRequest.js.map