"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = 'sync_queued_devices';
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            primaryKey: true
        },
        last_seen_time: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false
        },
        facility_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: 'facilities',
                key: 'id'
            }
        },
        last_synced_tick: {
            type: _sequelize.DataTypes.BIGINT,
            allowNull: false
        },
        urgent: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.addIndex(TABLE, [
        'id'
    ]);
    await query.addIndex(TABLE, [
        'last_seen_time'
    ]);
    await query.addIndex(TABLE, [
        'urgent'
    ]);
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1696818363249-addSyncQueuedDevice.js.map