"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MedicationDispense", {
    enumerable: true,
    get: function() {
        return MedicationDispense;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _model = require("../types/model");
const _dateTime = require("@tamanu/utils/dateTime");
const _sync = require("../sync");
let MedicationDispense = class MedicationDispense extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            quantity: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: false
            },
            instructions: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: true
            },
            dispensedAt: (0, _model.dateTimeType)('dispensedAt', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            })
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.PharmacyOrderPrescription, {
            foreignKey: 'pharmacyOrderPrescriptionId',
            as: 'pharmacyOrderPrescription'
        });
        this.belongsTo(models.User, {
            foreignKey: 'dispensedByUserId',
            as: 'dispensedBy'
        });
    }
    static getListReferenceAssociations() {
        return [
            'pharmacyOrderPrescription',
            'dispensedBy'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _sync.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'pharmacy_order_prescriptions',
            'pharmacy_orders',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _sync.buildEncounterPatientIdSelect)(this),
            joins: (0, _sync.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'pharmacy_order_prescriptions',
                'pharmacy_orders',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=MedicationDispense.js.map