import { FhirResource } from './Resource';
import type { InitOptions, Models } from '../../types/model';
export declare class FhirOrganization extends FhirResource {
    identifier?: Record<string, any>;
    name?: string;
    active?: boolean;
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    updateMaterialisation(): Promise<void>;
    static queryToFindUpstreamIdsFromTable(upstreamTable: string, table: string, id: string): Promise<{
        where: {
            id: string;
        };
    } | null>;
    static searchParameters(): {
        identifier: {
            type: string;
            path: string[][];
            tokenType: string;
        };
    };
}
//# sourceMappingURL=FhirOrganization.d.ts.map