"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    formatDateTimeForSchema: function() {
        return formatDateTimeForSchema;
    },
    processMock: function() {
        return processMock;
    }
});
const _zod = require("zod");
const _faker = require("@faker-js/faker");
const formatDateTimeForSchema = (date)=>{
    return date.toISOString().substring(0, 19).replace('T', ' ');
};
const isUnwrappable = (schema)=>schema instanceof _zod.z.ZodOptional || schema instanceof _zod.z.ZodNullable || schema instanceof _zod.z.ZodDefault || schema instanceof _zod.z.ZodArray;
const unwrap = (schema)=>{
    while(isUnwrappable(schema)){
        schema = schema.unwrap();
    }
    return schema;
};
const processMock = ({ schema, mock, excludedFields = [] })=>{
    const shape = schema.shape;
    for(const key in shape){
        const schemaEntry = unwrap(shape[key]);
        const schemaMeta = schemaEntry.meta();
        // For now we rely on custom field descriptions to determine how to fake the data
        if (typeof schemaMeta === 'object') {
            if (schemaMeta.description?.includes('__foreignKey__')) {
                mock[key] = undefined;
            } else if (schemaMeta.description?.includes('__dateCustomValidation__')) {
                mock[key] = _faker.faker.date.recent().toISOString().split('T')[0];
            } else if (schemaMeta.description?.includes('__datetimeCustomValidation__')) {
                mock[key] = formatDateTimeForSchema(_faker.faker.date.recent());
            }
        }
    }
    for (const field of excludedFields){
        delete mock[String(field)];
    }
    return mock;
};

//# sourceMappingURL=utils.js.map