import * as yup from 'yup';
export declare const centralSettings: {
    name: string;
    description: string;
    properties: {
        disk: {
            name: string;
            description: string;
            properties: {
                freeSpaceRequired: {
                    name: string;
                    description: string;
                    properties: {
                        gigabytesForUploadingDocuments: {
                            name: string;
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                    };
                };
            };
        };
        sync: {
            description: string;
            highRisk: boolean;
            properties: {
                streaming: {
                    properties: {
                        enabled: {
                            description: string;
                            type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                            defaultValue: boolean;
                        };
                        databasePollBatchSize: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                        databasePollInterval: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                    };
                };
            };
        };
        mobileSync: {
            description: string;
            highRisk: boolean;
            properties: {
                useUnsafeSchemaForInitialSync: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                maxBatchesToKeepInMemory: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                };
                maxRecordsPerInsertBatch: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                };
                maxRecordsPerUpdateBatch: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                };
                maxRecordsPerSnapshotBatch: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                };
                dynamicLimiter: {
                    description: string;
                    properties: {
                        initialLimit: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                        minLimit: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                        maxLimit: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                        maxLimitChangePerPage: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            defaultValue: number;
                        };
                        optimalTimePerPage: {
                            description: string;
                            type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                            unit: string;
                            defaultValue: number;
                        };
                    };
                };
            };
        };
        questionCodeIds: {
            deprecated: boolean;
            description: string;
            properties: {
                passport: {
                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                    defaultValue: any;
                };
                nationalityId: {
                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                    defaultValue: any;
                };
                email: {
                    type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                    defaultValue: any;
                };
            };
        };
        reportProcess: {
            properties: {
                timeOutDurationSeconds: {
                    description: string;
                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                    defaultValue: number;
                    unit: string;
                };
                runInChildProcess: {
                    description: string;
                    type: yup.BooleanSchema<boolean, yup.AnyObject, undefined, "">;
                    defaultValue: boolean;
                };
                processOptions: {
                    description: string;
                    type: yup.ArraySchema<string[], yup.AnyObject, undefined, "">;
                    defaultValue: any;
                };
                childProcessEnv: {
                    description: string;
                    type: yup.ObjectSchema<{}, yup.AnyObject, {}, "">;
                    defaultValue: any;
                };
                sleepAfterReport: {
                    description: string;
                    properties: {
                        duration: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        ifRunAtLeast: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        locationAssignments: {
            description: string;
            properties: {
                assignmentSlots: {
                    description: string;
                    properties: {
                        startTime: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        endTime: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        slotDuration: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                    };
                };
            };
        };
        integrations: {
            description: string;
            properties: {
                dhis2: {
                    description: string;
                    properties: {
                        host: {
                            description: string;
                            type: yup.StringSchema<string, yup.AnyObject, undefined, "">;
                            defaultValue: string;
                        };
                        reportIds: {
                            name: string;
                            description: string;
                            type: yup.ArraySchema<string[], yup.AnyObject, undefined, "">;
                            defaultValue: any[];
                            suggesterEndpoint: string;
                        };
                        idSchemes: {
                            description: string;
                            properties: {
                                dataElementIdScheme: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<"uid" | "name" | "code" | "attribute:ID", yup.AnyObject, undefined, "">;
                                    defaultValue: string;
                                };
                                orgUnitIdScheme: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<"uid" | "name" | "code" | "attribute:ID", yup.AnyObject, undefined, "">;
                                    defaultValue: string;
                                };
                                categoryOptionComboIdScheme: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<"uid" | "name" | "code" | "attribute:ID", yup.AnyObject, undefined, "">;
                                    defaultValue: string;
                                };
                                dataSetIdScheme: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<"uid" | "name" | "code" | "attribute:ID", yup.AnyObject, undefined, "">;
                                    defaultValue: string;
                                };
                                idScheme: {
                                    name: string;
                                    description: string;
                                    type: yup.StringSchema<"uid" | "name" | "code" | "attribute:ID", yup.AnyObject, undefined, "">;
                                    defaultValue: string;
                                };
                            };
                        };
                        backoff: {
                            name: string;
                            description: string;
                            properties: {
                                maxAttempts: {
                                    name: string;
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                };
                                multiplierMs: {
                                    name: string;
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                    unit: string;
                                };
                                maxWaitMs: {
                                    name: string;
                                    description: string;
                                    type: yup.NumberSchema<number, yup.AnyObject, undefined, "">;
                                    defaultValue: number;
                                    unit: string;
                                };
                            };
                        };
                    };
                };
            };
        };
    };
};
export declare const centralDefaults: any;
