import { isPlainObject } from 'lodash';
export const camelify = (str)=>{
    const [initial, ...subsequent] = str.split('_');
    const uppercased = subsequent.filter((x)=>x).map((s)=>s[0]?.toUpperCase() + s.slice(1));
    return [
        initial,
        ...uppercased
    ].join('');
};
export const renameObjectKeys = (baseObject)=>{
    return Object.keys(baseObject).reduce((rebuilt, currentKey)=>({
            ...rebuilt,
            [camelify(currentKey)]: baseObject[currentKey]
        }), {});
};
export const deepRenameObjectKeys = (baseObject)=>{
    if (!isPlainObject(baseObject)) return baseObject;
    return Object.keys(baseObject).reduce((rebuilt, currentKey)=>({
            ...rebuilt,
            [camelify(currentKey)]: typeof baseObject[currentKey] === 'object' && baseObject[currentKey] !== null ? deepRenameObjectKeys(baseObject[currentKey]) : baseObject[currentKey]
        }), {});
};

//# sourceMappingURL=renameObjectKeys.js.map