"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "invoicePriceListItemLoaderFactory", {
    enumerable: true,
    get: function() {
        return invoicePriceListItemLoaderFactory;
    }
});
const _constants = require("@tamanu/constants");
const _ProductMatrixByCodeLoaderFactory = require("./ProductMatrixByCodeLoaderFactory");
const { HIDDEN } = _constants.INVOICE_PRICE_LIST_ITEM_IMPORT_VALUES;
function invoicePriceListItemLoaderFactory() {
    return (0, _ProductMatrixByCodeLoaderFactory.productMatrixByCodeLoaderFactory)({
        parentModel: 'InvoicePriceList',
        itemModel: 'InvoicePriceListItem',
        parentIdField: 'invoicePriceListId',
        valueField: 'price',
        valueExtractor: (value, isEmpty)=>{
            const isSpecialValue = isEmpty || value === HIDDEN;
            const parsedValue = isSpecialValue ? null : Number(value);
            const isValidValue = isSpecialValue ? true : !Number.isNaN(parsedValue);
            const isHidden = value === HIDDEN;
            return {
                parsedValue,
                isValidValue,
                isHidden
            };
        },
        allowEmptyValues: true,
        messages: {
            duplicateCode: (code)=>`duplicate price list code: ${code}`,
            missingParentByCode: (code)=>`InvoicePriceList with code '${code}' does not exist`,
            couldNotFindParentId: (code)=>`Could not find InvoicePriceList ID for code '${code}'`,
            invalidValue: (raw, code, invoiceProductId)=>`Invalid price value '${raw}' for priceList '${code}' and invoiceProductId '${invoiceProductId}'`
        }
    });
}

//# sourceMappingURL=invoicePriceListItemLoaderFactory.js.map