"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "authModule", {
    enumerable: true,
    get: function() {
        return authModule;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _middleware = require("@tamanu/shared/permissions/middleware");
const _convertDbRecord = require("../convertDbRecord");
const _changePassword = require("./changePassword");
const _resetPassword = require("./resetPassword");
const _login = require("./login");
const _refresh = require("./refresh");
const _setFacility = require("./setFacility");
const _userMiddleware = require("./userMiddleware");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const authModule = _express.default.Router();
authModule.use('/resetPassword', _resetPassword.resetPassword);
authModule.use('/changePassword', _changePassword.changePassword);
authModule.post('/login', _login.login);
authModule.post('/refresh', _refresh.refresh);
authModule.use(_userMiddleware.userMiddleware);
authModule.get('/user/me', _userMiddleware.userInfo);
authModule.post('/setFacility', _setFacility.setFacility);
authModule.get('/permissions', (0, _expressasynchandler.default)(_middleware.getPermissions));
authModule.get('/whoami', (0, _expressasynchandler.default)((req, res)=>{
    res.send((0, _convertDbRecord.convertFromDbRecord)(req.user).data);
}));

//# sourceMappingURL=index.js.map