"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "parseQuery", {
    enumerable: true,
    get: function() {
        return parseQuery;
    }
});
const _search = require("./search");
function parseQuery(unsafeQuery, querySchema) {
    const { searchId, ...rest } = unsafeQuery;
    let values = rest;
    if (searchId) {
        values = (0, _search.fromSearchId)(searchId);
    }
    /*
    Validation notes:
  
    - stripUnknown needs to be false because otherwise yup will
    remove those fields before validation occurs. We want to throw
    an error message when the query has unsupported parameters.
  
    - abortEarly needs to be false because we want to return a list of
    all errors found.
  
    - We can't validate schema strictly because we want defaults for
    required fields and possibly type coercion.
    */ return querySchema.validate(values, {
        stripUnknown: false,
        abortEarly: false
    });
}

//# sourceMappingURL=parseQuery.js.map