"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    // Create a lang=en collation that sorts numbers naturally
    await query.sequelize.query(`
    CREATE COLLATION en_numeric (provider = icu, locale = 'en@colNumeric=yes');
  `);
    // Apply natural sorting order to locations and areas
    await query.sequelize.query('ALTER TABLE locations ALTER COLUMN name TYPE character varying(255) COLLATE en_numeric');
    await query.sequelize.query('ALTER TABLE location_groups ALTER COLUMN name TYPE character varying(255) COLLATE en_numeric');
}
async function down(query) {
    await query.sequelize.query('ALTER TABLE locations ALTER COLUMN name TYPE character varying(255) COLLATE "default"');
    await query.sequelize.query('ALTER TABLE location_groups ALTER COLUMN name TYPE character varying(255) COLLATE "default"');
    await query.sequelize.query('DROP COLLATION en_numeric;');
}

//# sourceMappingURL=1708482392584-collateLocationsNaturally.js.map