"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.renameColumn('invoice_items', 'product_name', 'product_name_final');
    await query.renameColumn('invoice_items', 'product_code', 'product_code_final');
    await query.renameColumn('invoice_items', 'product_price', 'manual_entry_price');
    await query.addColumn('invoice_items', 'price_final', {
        type: _sequelize.DataTypes.DECIMAL,
        allowNull: true
    });
    await query.removeColumn('invoice_items', 'product_discountable');
}
async function down(query) {
    await query.removeColumn('invoice_items', 'price_final');
    await query.renameColumn('invoice_items', 'manual_entry_price', 'product_price');
    await query.renameColumn('invoice_items', 'product_code_final', 'product_code');
    await query.renameColumn('invoice_items', 'product_name_final', 'product_name');
    await query.addColumn('invoice_items', 'product_discountable', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
}

//# sourceMappingURL=1764037831379-renameInvoiceItemSavedFieldsAddPriceFinal.js.map