"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoicesInvoiceInsurancePlan", {
    enumerable: true,
    get: function() {
        return InvoicesInvoiceInsurancePlan;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("../Model");
const _buildEncounterLinkedSyncFilter = require("../../sync/buildEncounterLinkedSyncFilter");
const _buildEncounterLinkedLookupFilter = require("../../sync/buildEncounterLinkedLookupFilter");
let InvoicesInvoiceInsurancePlan = class InvoicesInvoiceInsurancePlan extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            invoiceId: {
                type: _sequelize.DataTypes.UUID,
                allowNull: false
            },
            invoiceInsurancePlanId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            indexes: [
                {
                    fields: [
                        'invoiceId'
                    ]
                },
                {
                    fields: [
                        'invoiceInsurancePlanId'
                    ]
                },
                {
                    unique: true,
                    fields: [
                        'invoiceId',
                        'invoiceInsurancePlanId'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Invoice, {
            foreignKey: 'invoiceId',
            as: 'invoice'
        });
        this.belongsTo(models.InvoiceInsurancePlan, {
            foreignKey: 'invoiceInsurancePlanId',
            as: 'invoiceInsurancePlan'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupSelect)(this),
            joins: (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupJoins)(this, [
                'invoices',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=InvoicesInvoiceInsurancePlan.js.map