"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProgramDataElement", {
    enumerable: true,
    get: function() {
        return ProgramDataElement;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _safeJsonParse = require("@tamanu/utils/safeJsonParse");
const _Model = require("./Model");
let ProgramDataElement = class ProgramDataElement extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: _sequelize.DataTypes.STRING,
            name: _sequelize.DataTypes.STRING,
            indicator: _sequelize.DataTypes.STRING,
            defaultText: _sequelize.DataTypes.STRING,
            defaultOptions: _sequelize.DataTypes.TEXT,
            visualisationConfig: _sequelize.DataTypes.TEXT,
            type: {
                type: _sequelize.DataTypes.STRING(31),
                allowNull: false
            }
        }, {
            ...options,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ],
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.hasOne(models.SurveyScreenComponent, {
            foreignKey: 'dataElementId',
            as: 'surveyScreenComponent'
        });
    }
    forResponse() {
        const { defaultOptions, ...values } = this.dataValues;
        return {
            ...values,
            defaultOptions: (0, _safeJsonParse.safeJsonParse)(defaultOptions)
        };
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ProgramDataElement.js.map