import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
export class ReferenceMedicationTemplate extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            isOngoing: {
                type: DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: false
            },
            isPrn: {
                type: DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: false
            },
            isVariableDose: {
                type: DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: false
            },
            doseAmount: DataTypes.DECIMAL,
            units: {
                type: DataTypes.STRING,
                allowNull: false
            },
            frequency: {
                type: DataTypes.STRING,
                allowNull: false
            },
            route: {
                type: DataTypes.STRING,
                allowNull: false
            },
            durationValue: DataTypes.DECIMAL,
            durationUnit: DataTypes.STRING,
            notes: DataTypes.STRING,
            dischargeQuantity: DataTypes.INTEGER
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'medicationId',
            as: 'medication'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'referenceDataId',
            as: 'referenceData'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
}

//# sourceMappingURL=ReferenceMedicationTemplate.js.map