function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import { get as lodashGet, pick } from 'lodash';
import { buildSettings } from '..';
import { settingsCache } from '../cache';
export const KEYS_EXPOSED_TO_FRONT_END = [
    'audit',
    'appointments',
    'ageDisplayFormat',
    'customisations',
    'features',
    'fields',
    'imagingCancellationReasons',
    'imagingPriorities',
    'insurer',
    'customisations',
    'locationAssignments',
    'printMeasures',
    'invoice',
    'labsCancellationReasons',
    'templates',
    'layouts',
    'security.mobile',
    'triageCategories',
    'upcomingVaccinations',
    'vaccinations',
    'vitalEditReasons',
    'medications',
    'sync',
    'mobileSync',
    'patientDisplayIdPattern'
];
export const KEYS_EXPOSED_TO_PATIENT_PORTAL = [
    'features',
    'fileChooserMbSizeLimit'
];
export class ReadSettings {
    async get(key) {
        const settings = await this.getAll();
        return lodashGet(settings, key);
    }
    // This is what is called on tamanu-web login. This gets only settings relevant to
    // the frontend so only what is needed is sent. No sensitive data is sent.
    async getFrontEndSettings() {
        const allSettings = await this.getAll();
        return pick(allSettings, KEYS_EXPOSED_TO_FRONT_END);
    }
    async getPatientPortalSettings() {
        const allSettings = await this.getAll();
        return pick(allSettings, KEYS_EXPOSED_TO_PATIENT_PORTAL);
    }
    async getAll() {
        let settings = settingsCache.getAllSettings(this.facilityId);
        if (!settings) {
            settings = await buildSettings(this.models, this.facilityId);
            settingsCache.setAllSettings(settings, this.facilityId);
        }
        return settings;
    }
    constructor(models, facilityId){
        _define_property(this, "models", void 0);
        _define_property(this, "facilityId", void 0);
        this.models = models;
        this.facilityId = facilityId;
    }
}

//# sourceMappingURL=ReadSettings.js.map