"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirImmunizationProtocolApplied", {
    enumerable: true,
    get: function() {
        return FhirImmunizationProtocolApplied;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _chance = require("chance");
const _lodash = require("lodash");
const _codeableConcept = require("./codeableConcept");
const _reference = require("./reference");
const _baseType = require("./baseType");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
let FhirImmunizationProtocolApplied = class FhirImmunizationProtocolApplied extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            series: _yup.string().nullable().default(null),
            authority: _reference.FhirReference.asYup().nullable(),
            targetDisease: _yup.array().of(_codeableConcept.FhirCodeableConcept.asYup()).nullable().default([]),
            doseNumberPositiveInt: _yup.number().positive().integer().min(1).nullable().default(null),
            doseNumberString: _yup.string().nullable().default(null),
            seriesDosesPositiveInt: _yup.number().positive().integer().min(1).nullable().default(null),
            seriesDosesString: _yup.string().nullable().default(null)
        }).test('doseNumber[x]', 'doseNumberPositiveInt or doseNumberString is required', ({ doseNumberPositiveInt, doseNumberString })=>{
            return doseNumberPositiveInt !== null || doseNumberString !== null;
        }).noUnknown();
    }
    static fake(...args) {
        const chance = new _chance.Chance();
        const targetDisease = Array((0, _lodash.random)(0, 3)).fill(0).map(()=>_codeableConcept.FhirCodeableConcept.fake(...args));
        return new this({
            series: chance.string(),
            authority: _reference.FhirReference.fake(...args),
            targetDisease,
            doseNumberString: chance.pickone([
                'one',
                'two',
                'three',
                'four'
            ]),
            seriesDosesString: chance.string()
        });
    }
};

//# sourceMappingURL=immunizationProtocolApplied.js.map