"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getDisplayDate", {
    enumerable: true,
    get: function() {
        return getDisplayDate;
    }
});
const _datefnstz = require("date-fns-tz");
const _dateTime = require("@tamanu/utils/dateTime");
const DEFAULT_DATE_FORMAT = 'dd/MM/yyyy';
const getDisplayDate = (date, format = DEFAULT_DATE_FORMAT, getLocalisation)=>{
    // Format the date if it's passed in
    if (date) {
        return (0, _dateTime.format)(date, format);
    }
    // Display the current date in a configured timezone if one is set
    if (getLocalisation && getLocalisation('timeZone')) {
        return (0, _datefnstz.formatInTimeZone)(new Date(), getLocalisation('timeZone'), format);
    }
    // Finally return a current date
    return (0, _dateTime.format)(new Date(), format);
};

//# sourceMappingURL=getDisplayDate.js.map