import { SEX_VALUES } from '@tamanu/constants';
export type LabTestTypeLike = {
    maleMax?: number;
    femaleMax?: number;
    maleMin?: number;
    femaleMin?: number;
    rangeText?: string;
    unit?: string;
};
type getTranslation = (stringId: string, fallback: string, translationOptions?: {
    casing?: 'lower' | 'upper' | 'sentence';
    replacements?: Record<string, any>;
}) => string;
interface GetReferenceRangeProps<T extends LabTestTypeLike = LabTestTypeLike> {
    labTestType?: T;
    sex?: keyof typeof SEX_VALUES | null;
    getTranslation: getTranslation;
}
export declare const getReferenceRange: ({ labTestType, sex, getTranslation }: GetReferenceRangeProps) => string;
export declare const getReferenceRangeWithUnit: ({ labTestType, sex, getTranslation, }: GetReferenceRangeProps) => string;
export {};
//# sourceMappingURL=labTests.d.ts.map