"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    schema: 'fhir',
    tableName: 'service_requests'
};
async function up(query) {
    await query.changeColumn(TABLE, 'status', _sequelize.DataTypes.TEXT, {
        allowNull: false
    });
    await query.changeColumn(TABLE, 'intent', _sequelize.DataTypes.TEXT, {
        allowNull: false
    });
    await query.changeColumn(TABLE, 'priority', _sequelize.DataTypes.TEXT);
    await query.addColumn(TABLE, 'code', 'fhir.codeable_concept');
    await query.removeColumn(TABLE, 'subject');
    await query.addColumn(TABLE, 'subject', 'fhir.reference', {
        allowNull: false
    });
    await query.removeColumn(TABLE, 'requester');
    await query.addColumn(TABLE, 'requester', 'fhir.reference');
    await query.removeColumn(TABLE, 'occurrence_date_time');
    await query.addColumn(TABLE, 'occurrence_date_time', {
        type: _sequelize.DataTypes.DATE,
        allowNull: true
    });
}
async function down(query) {
    await query.changeColumn(TABLE, 'status', _sequelize.DataTypes.STRING(16), {
        allowNull: false
    });
    await query.changeColumn(TABLE, 'intent', _sequelize.DataTypes.STRING(16), {
        allowNull: false
    });
    await query.changeColumn(TABLE, 'priority', _sequelize.DataTypes.STRING(10));
    await query.removeColumn(TABLE, 'code');
    await query.removeColumn(TABLE, 'subject');
    await query.addColumn(TABLE, 'subject', _sequelize.DataTypes.UUID, {
        allowNull: false,
        references: {
            model: {
                schema: 'fhir',
                tableName: 'patients'
            },
            key: 'id'
        }
    });
    await query.removeColumn(TABLE, 'requester');
    await query.addColumn(TABLE, 'requester', _sequelize.DataTypes.UUID, {
        allowNull: true,
        references: {
            model: {
                schema: 'fhir',
                tableName: 'practitioners'
            },
            key: 'id'
        }
    });
    await query.removeColumn(TABLE, 'occurrence_date_time');
    await query.addColumn(TABLE, 'occurrence_date_time', {
        type: 'date_time_string',
        allowNull: true
    });
}

//# sourceMappingURL=1668567358308-fhirServiceRequestExtraFields.js.map