"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    ALTER TABLE user_login_attempts
    DROP CONSTRAINT IF EXISTS user_login_attempts_device_id_fkey;
  `);
    await query.sequelize.query(`
    CREATE INDEX IF NOT EXISTS user_login_attempts_device_id ON user_login_attempts (device_id);
  `);
}
async function down(query) {
    await query.removeIndex('user_login_attempts', [
        'device_id'
    ]);
    await query.sequelize.query(`
    DELETE FROM user_login_attempts
    WHERE device_id IS NOT NULL
    AND NOT EXISTS (SELECT 1 FROM devices WHERE devices.id = user_login_attempts.device_id);
  `);
    await query.addConstraint('user_login_attempts', {
        fields: [
            'device_id'
        ],
        type: 'foreign key',
        name: 'user_login_attempts_device_id_fkey',
        references: {
            table: 'devices',
            field: 'id'
        },
        onDelete: 'NO ACTION',
        onUpdate: 'NO ACTION'
    });
}

//# sourceMappingURL=1768858451324-removeDeviceFkFromUserLoginAttempts.js.map