import * as yup from 'yup';
import { FhirResource } from './Resource';
import { type FhirEndpointType } from './fhirEndpoint';
import type { InitOptions, Models } from '../../types/model';
import type { ImagingRequest } from '../../models/ImagingRequest';
export declare class FhirImagingStudy extends FhirResource {
    identifier?: {
        system: string;
        value: string;
    }[];
    basedOn?: Record<string, any>[];
    started?: string;
    status: string;
    note?: {
        text: string;
    }[];
    contained?: FhirEndpointType[];
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    static get INTAKE_SCHEMA(): import("yup/lib/object").OptionalObjectSchema<{
        identifier: any;
        basedOn: yup.ArraySchema<import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>, import("yup/lib/types").AnyObject, any[] | undefined, any[] | undefined>;
        started: yup.StringSchema<string | undefined, import("yup/lib/types").AnyObject, string | undefined>;
        status: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        note: yup.ArraySchema<import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>, import("yup/lib/types").AnyObject, any[] | undefined, any[] | undefined>;
        contained: any;
    }, import("yup/lib/object").AnyObject, import("yup/lib/object").TypeOfShape<{
        identifier: any;
        basedOn: yup.ArraySchema<import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>, import("yup/lib/types").AnyObject, any[] | undefined, any[] | undefined>;
        started: yup.StringSchema<string | undefined, import("yup/lib/types").AnyObject, string | undefined>;
        status: import("yup/lib/string").RequiredStringSchema<string | undefined, import("yup/lib/types").AnyObject>;
        note: yup.ArraySchema<import("yup/lib/mixed").MixedSchema<any, import("yup/lib/types").AnyObject, any>, import("yup/lib/types").AnyObject, any[] | undefined, any[] | undefined>;
        contained: any;
    }>>;
    pushUpstream({ settings, requesterId, }: {
        settings: Record<string, any>;
        requesterId: string;
    }): Promise<import("..").ImagingResult | undefined>;
    cancelRequest(imagingRequest: ImagingRequest, requesterId: string, settings: Record<string, any>): Promise<void>;
    attachResults(imagingRequest: ImagingRequest): Promise<import("..").ImagingResult>;
}
//# sourceMappingURL=FhirImagingStudy.d.ts.map