"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "invoiceForResponse", {
    enumerable: true,
    get: function() {
        return invoiceForResponse;
    }
});
const _lodash = require("lodash");
const invoiceForResponse = (invoiceRecord)=>{
    const processedItems = invoiceRecord.items.map((item)=>{
        const plainItem = item.get?.({
            plain: true
        }) ?? item;
        const productCode = item.product?.getProductCode?.() ?? null;
        if (!item.product?.insurable) {
            return {
                ...plainItem,
                productCode
            };
        }
        const insurancePlansById = (0, _lodash.keyBy)(item.product?.invoiceInsurancePlanItems, 'invoiceInsurancePlanId');
        const insurancePlanItems = invoiceRecord.insurancePlans?.map(({ id, code, name, defaultCoverage })=>{
            const planItem = insurancePlansById[id];
            const coverageValue = planItem?.coverageValue ?? defaultCoverage;
            return {
                id,
                code,
                name,
                label: name ?? code,
                coverageValue
            };
        }) ?? [];
        return {
            ...plainItem,
            insurancePlanItems,
            productCode
        };
    });
    // Convert to plain object to avoid circular references
    const plainInvoice = invoiceRecord.get?.({
        plain: true
    }) ?? invoiceRecord;
    return {
        ...plainInvoice,
        items: processedItems
    };
};

//# sourceMappingURL=invoiceForResponse.js.map