"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    facilityDefaults: function() {
        return facilityDefaults;
    },
    facilitySettings: function() {
        return facilitySettings;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _utils = require("./utils");
const _definitions = require("./definitions");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const facilitySettings = {
    name: 'Facility server settings',
    description: 'Settings that apply only to a facility server',
    properties: {
        appointments: {
            description: 'Settings related to scheduling patient appointments and location bookings',
            properties: {
                bookingSlots: {
                    description: 'Configure the available booking slots for appointments',
                    properties: {
                        startTime: {
                            description: 'The time when bookings open for the day. (The earliest start time for a booking.) Uses 24-hour time, e.g. 13:30.',
                            type: _definitions.datelessTimeStringSchema,
                            defaultValue: '09:00'
                        },
                        endTime: {
                            description: 'The time when bookings close for the day. (The latest booking must end by this time.) Uses 24-hour time, e.g. 13:30.',
                            type: _definitions.datelessTimeStringSchema,
                            defaultValue: '17:00'
                        },
                        slotDuration: {
                            description: 'The length of each time slot. A single booking may span multiple consecutive slots. Supported units: ‘min’, ‘h’',
                            type: (0, _definitions.durationStringSchema)('slotDuration'),
                            defaultValue: '30min'
                        }
                    }
                }
            }
        },
        certifications: {
            properties: {
                covidClearanceCertificate: {
                    properties: {
                        after: {
                            name: 'After date',
                            description: 'The date after which the test is valid',
                            type: _yup.string().matches(/^\d{4}-\d{2}-\d{2}$/, 'Date must be in the format YYYY-MM-DD'),
                            defaultValue: '2022-09-01'
                        },
                        daysSinceSampleTime: {
                            description: '-',
                            type: _yup.number().integer().positive(),
                            defaultValue: 13
                        },
                        labTestCategories: {
                            description: 'List of valid lab test categories',
                            type: _yup.array().of(_yup.string()),
                            defaultValue: []
                        },
                        labTestTypes: {
                            description: 'List of valid lab test types',
                            type: _yup.array().of(_yup.string()),
                            defaultValue: []
                        },
                        labTestResults: {
                            description: 'List of valid lab test results',
                            type: _yup.array().of(_yup.string()),
                            defaultValue: [
                                'Positive'
                            ]
                        }
                    }
                }
            }
        },
        patientDisplayIdPattern: {
            highRisk: true,
            description: `The pattern to use for generating patient display IDs.
        'A' will be replaced with a random letter and '0' will be replaced with a random number.
        Wrapping characters in [] will allow static characters to be used. For example,
        '[B]AAAA000000' will generate an 11 character ID with a static B followed by 4 letter and 6 numbers.`,
            type: _yup.string().matches(/^(?:(?:\[.+?\])(?=\[|[A0]|$)|[A0])+$/, 'Invalid pattern'),
            defaultValue: 'AAAA000000'
        },
        questionCodeIds: {
            deprecated: true,
            description: _definitions.questionCodeIdsDescription,
            properties: {
                passport: {
                    type: _definitions.passportSchema,
                    defaultValue: 'pde-FijCOVRDT005'
                },
                nationalityId: {
                    type: _definitions.nationalityIdSchema,
                    defaultValue: 'pde-PalauCOVSamp7'
                },
                email: {
                    type: _definitions.emailSchema,
                    defaultValue: null
                }
            }
        },
        sync: {
            description: 'Facility sync settings',
            highRisk: true,
            properties: {
                syncAllLabRequests: {
                    description: '_',
                    type: _yup.boolean(),
                    defaultValue: false
                },
                urgentIntervalInSeconds: {
                    name: 'Sync urgent interval',
                    unit: 'seconds',
                    description: 'Mobile urgent sync interval',
                    type: _yup.number().integer().positive(),
                    defaultValue: 10
                }
            }
        },
        vaccinations: _definitions.vaccinationsSchema,
        medications: {
            name: 'Medication',
            description: 'Settings related to medication management and dispensing',
            properties: {
                medicationDispensing: {
                    name: 'Medication dispensing',
                    description: 'Settings for automatic encounter generation when sending medication requests to pharmacy from ongoing medications table',
                    properties: {
                        automaticEncounterLocationId: {
                            name: 'Automatic encounter location',
                            description: 'Set the default location for the automatic encounter generated when sending a medication request to pharmacy from the ongoing medications table',
                            type: _yup.string().nullable(),
                            defaultValue: null,
                            suggesterEndpoint: 'location'
                        },
                        automaticEncounterDepartmentId: {
                            name: 'Automatic encounter department',
                            description: 'Set the default department for the automatic encounter generated when sending a medication request to pharmacy from the ongoing medications table',
                            type: _yup.string().nullable(),
                            defaultValue: null,
                            suggesterEndpoint: 'department'
                        }
                    }
                }
            }
        },
        survey: {
            name: 'Survey settings',
            description: '_',
            properties: {
                defaultCodes: {
                    description: 'Default reference data codes to use when creating a survey encounter (includes vitals) when none are explicitly specified',
                    properties: {
                        department: {
                            description: 'Default department code',
                            type: _yup.string(),
                            defaultValue: 'GeneralClinic'
                        },
                        location: {
                            description: 'Default location code',
                            type: _yup.string(),
                            defaultValue: 'GeneralClinic'
                        }
                    }
                }
            }
        },
        templates: {
            description: 'Text to be inserted into emails/PDFs',
            properties: {
                letterhead: {
                    description: 'The text at the top of most patient PDFs',
                    properties: _definitions.letterheadProperties
                }
            }
        }
    }
};
const facilityDefaults = (0, _utils.extractDefaults)(facilitySettings);

//# sourceMappingURL=facility.js.map