"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getTracer: function() {
        return getTracer;
    },
    spanWrapFn: function() {
        return spanWrapFn;
    }
});
const _api = require("@opentelemetry/api");
const getTracer = (name = 'tamanu')=>_api.trace.getTracer(name);
const spanWrapFn = async (name, fn, attributes = {}, tracer = 'tamanu')=>getTracer(tracer).startActiveSpan(name, async (span)=>{
        span.setAttribute('code.function', name);
        span.setAttributes(attributes);
        try {
            return await fn(span);
        } catch (e) {
            span.recordException(e);
            throw e;
        } finally{
            span.end();
        }
    });

//# sourceMappingURL=tracing.js.map