import { basename, extname } from 'node:path';
export const START = ':start:';
export const END = ':end:';
export const MIGRATION_PREFIX = 'migration/';
export const STEP_PREFIX = 'upgrade/';
export const needsStep = (step)=>{
    const re = RegExp("^(?<file>.+?)(\\/(?<index>\\d+))?$");
    const { file, index } = re.exec(step)?.groups || {};
    if (!file) throw new Error(`Invalid step name: ${step}`);
    if (!index) throw new Error('You must provide an index when depending on upgrade steps');
    return `upgrade/${basename(file, extname(file))}/${index}`;
};
export const needsMigration = (mig)=>`migration/${basename(mig, extname(mig))}`;
export const onlySteps = (needs)=>needs.filter((need)=>need.startsWith(STEP_PREFIX));
export const onlyMigrations = (needs)=>needs.filter((need)=>need.startsWith(MIGRATION_PREFIX));
export const stepFile = (str)=>str.split('/')[1] + '.js';
export const migrationFile = (str)=>str.split('/')[1] + '.js';

//# sourceMappingURL=step.js.map