"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoicePriceListItemExporter", {
    enumerable: true,
    get: function() {
        return InvoicePriceListItemExporter;
    }
});
const _constants = require("@tamanu/constants");
const _ProductMatrixByCodeExporter = require("./ProductMatrixByCodeExporter");
const { HIDDEN } = _constants.INVOICE_PRICE_LIST_ITEM_IMPORT_VALUES;
let InvoicePriceListItemExporter = class InvoicePriceListItemExporter extends _ProductMatrixByCodeExporter.ProductMatrixByCodeExporter {
    constructor(context, dataType){
        super(context, dataType, {
            parentModel: 'InvoicePriceList',
            itemModel: 'InvoicePriceListItem',
            parentIdField: 'invoicePriceListId',
            valueField: 'price',
            valueExtractor: (item)=>{
                const { price, isHidden } = item;
                if (isHidden) return HIDDEN;
                return price;
            },
            itemModelAttributes: [
                'isHidden'
            ],
            tabName: 'Invoice Price List Items'
        });
    }
};

//# sourceMappingURL=InvoicePriceListItemExporter.js.map