"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ModelExporter", {
    enumerable: true,
    get: function() {
        return ModelExporter;
    }
});
const _lodash = require("lodash");
const _sequelize = require("sequelize");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
const METADATA_COLUMNS = [
    'createdAt',
    'updatedAt',
    'deletedAt',
    'updatedAtSyncTick',
    'updatedAtByField'
];
let ModelExporter = class ModelExporter {
    async getData() {
        throw new Error('getData() method not implemented');
    }
    getHeaders(data) {
        return this.getHeadersFromData(data).filter((header)=>!this.hiddenColumns().includes(header));
    }
    getTabName() {
        return this.customTabName() || (0, _lodash.startCase)(this.dataType);
    }
    formattedCell(header, value) {
        if (!value) {
            return value;
        }
        const formatter = this.customCellFormatter[header];
        if (formatter) {
            return formatter(value);
        }
        return value;
    }
    customTabName() {
        return null;
    }
    getHeadersFromData(data) {
        const allKeys = new Set();
        data.forEach((row)=>{
            const rowData = row instanceof _sequelize.Model ? row.dataValues : row;
            Object.keys(rowData).forEach((key)=>allKeys.add(key));
        });
        return Array.from(allKeys);
    }
    customHiddenColumns() {
        return [];
    }
    hiddenColumns() {
        return [
            ...METADATA_COLUMNS,
            ...this.customHiddenColumns()
        ];
    }
    constructor({ models, sequelize }, dataType){
        _define_property(this, "customCellFormatter", {});
        this.models = models;
        this.sequelize = sequelize;
        this.dataType = dataType;
    }
};

//# sourceMappingURL=ModelExporter.js.map