"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, // All reference data is imported first, so that can be assumed for ordering.
//
// sheetNameNormalised: {
//   model: 'ModelName' (defaults to `upperFirst(sheetNameNormalised)`),
//   loader: fn(item) => Array<LoadRow> (defaults to `loaderFactory(Model)`),
//   needs: ['otherSheetNames', 'thisOneNeeds'] (defaults to `[]`),
// }
//
// where interface LoadRow { model: string; values: object; }
//
// creating dependency cycles will (intentionally) crash the importer
"default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const _constants = require("@tamanu/constants");
const _loaders = require("./loaders");
const _invoicePriceListItemLoaderFactory = require("./invoicePriceListItemLoaderFactory");
const _invoiceInsurancePlanItemLoaderFactory = require("./invoiceInsurancePlanItemLoaderFactory");
const _default = {
    user: {
        loader: _loaders.userLoader,
        needs: [
            'facility'
        ]
    },
    patient: {
        loader: _loaders.patientDataLoader,
        needs: [
            'user',
            'patientFieldDefinition'
        ]
    },
    facility: {},
    department: {
        needs: [
            'facility'
        ]
    },
    locationGroup: {
        needs: [
            'facility'
        ]
    },
    location: {
        needs: [
            'facility',
            'locationGroup'
        ]
    },
    userFacility: {
        needs: [
            'facility',
            'user'
        ]
    },
    certifiableVaccine: {},
    scheduledVaccine: {},
    administeredVaccine: {
        loader: _loaders.administeredVaccineLoader,
        needs: [
            'scheduledVaccine',
            'user',
            'location',
            'department'
        ]
    },
    labTestType: {},
    labTestPanel: {
        loader: _loaders.labTestPanelLoader,
        needs: [
            'labTestType'
        ]
    },
    invoiceProduct: {
        loader: _loaders.invoiceProductLoader,
        needs: [
            _constants.OTHER_REFERENCE_TYPES.LAB_TEST_TYPE,
            _constants.OTHER_REFERENCE_TYPES.LAB_TEST_PANEL
        ]
    },
    invoicePriceList: {},
    invoicePriceListItem: {
        get loader () {
            // Use a getter to create a fresh loader instance on each access
            return (0, _invoicePriceListItemLoaderFactory.invoicePriceListItemLoaderFactory)();
        },
        needs: [
            'invoicePriceList',
            'invoiceProduct'
        ]
    },
    // Insurance plans and items (mirror price lists & items)
    invoiceInsurancePlan: {},
    invoiceInsurancePlanItem: {
        get loader () {
            // Create a fresh loader instance on each access
            return (0, _invoiceInsurancePlanItemLoaderFactory.invoiceInsurancePlanItemLoaderFactory)();
        },
        needs: [
            'invoiceInsurancePlan',
            'invoiceProduct'
        ]
    },
    role: {},
    permission: {
        loader: _loaders.permissionLoader,
        needs: [
            'role'
        ]
    },
    patientFieldDefinitionCategory: {},
    patientFieldDefinition: {
        loader: _loaders.patientFieldDefinitionLoader,
        needs: [
            'patientFieldDefinitionCategory'
        ]
    },
    imagingAreaExternalCode: {},
    imagingTypeExternalCode: {},
    translatedString: {
        loader: _loaders.translatedStringLoader
    },
    referenceDataRelation: {},
    [_constants.REFERENCE_TYPES.TASK_TEMPLATE]: {
        loader: _loaders.taskTemplateLoader
    },
    [_constants.REFERENCE_TYPES.TASK_SET]: {
        loader: _loaders.taskSetLoader
    },
    [_constants.REFERENCE_TYPES.DRUG]: {
        loader: _loaders.drugLoader
    },
    [_constants.REFERENCE_TYPES.MEDICATION_TEMPLATE]: {
        loader: _loaders.medicationTemplateLoader
    },
    [_constants.REFERENCE_TYPES.MEDICATION_SET]: {
        loader: _loaders.medicationSetLoader
    },
    [_constants.REFERENCE_TYPES.PROCEDURE_TYPE]: {
        loader: _loaders.procedureTypeLoader
    }
};

//# sourceMappingURL=dependencies.js.map