"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "surveyResponsesImporter", {
    enumerable: true,
    get: function() {
        return surveyResponsesImporter;
    }
});
const _logging = require("@tamanu/shared/services/logging");
const _xlsx = require("xlsx");
const _importSurveyResponses = require("./importSurveyResponses");
async function surveyResponsesImporter({ errors, models, stats, file, checkPermission }) {
    const createContext = (sheetName)=>({
            errors,
            log: _logging.log.child({
                file,
                sheetName
            }),
            models
        });
    _logging.log.info('Importing survey responses from file', {
        file
    });
    checkPermission('create', 'SurveyResponse');
    const workbook = (0, _xlsx.readFile)(file);
    stats.push(await (0, _importSurveyResponses.importSurveyResponses)(workbook, createContext('Survey Responses')));
    _logging.log.debug('Done importing survey responses');
}

//# sourceMappingURL=surveyResponsesImporter.js.map