"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    userInfo: function() {
        return userInfo;
    },
    userMiddleware: function() {
        return userMiddleware;
    }
});
const _api = require("@opentelemetry/api");
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _errors = require("@tamanu/errors");
const _logging = require("@tamanu/shared/services/logging");
const _createSessionIdentifier = require("@tamanu/shared/audit/createSessionIdentifier");
const _utils = require("./utils");
const _audit = require("@tamanu/database/utils/audit");
const _packagejson = require("../../package.json");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const userMiddleware = (0, _expressasynchandler.default)(async (req, res, next)=>{
    const { auth: { secret, tokenDuration }, canonicalHostName } = _config.default;
    const { store: { models: { User } }, settings } = req;
    const { token, user, device } = await User.loginFromAuthorizationHeader(req.get('authorization'), {
        log: _logging.log,
        settings,
        tokenDuration,
        tokenIssuer: canonicalHostName,
        tokenSecret: secret
    });
    const sessionId = (0, _createSessionIdentifier.createSessionIdentifier)(token);
    /* eslint-disable require-atomic-updates */ // in this case we don't care if we're overwriting the user/deviceId
    // and express also guarantees execution order for middlewares
    req.user = user;
    req.deviceId = device?.id;
    req.device = device;
    req.sessionId = sessionId;
    /* eslint-enable require-atomic-updates */ const auditSettings = await settings?.[req.facilityId]?.get('audit');
    // Auditing middleware
    req.audit = (0, _audit.initAuditActions)(req, {
        enabled: auditSettings?.accesses.enabled,
        userId: user.id,
        version: _packagejson.version,
        backEndContext: {
            serverType: _constants.SERVER_TYPES.CENTRAL
        }
    });
    const spanAttributes = user ? {
        'app.user.id': user.id,
        'app.user.role': user.role
    } : {};
    // eslint-disable-next-line no-unused-expressions
    _api.trace.getActiveSpan()?.setAttributes(spanAttributes);
    _api.context.with(_api.propagation.setBaggage(_api.context.active(), _api.propagation.createBaggage(spanAttributes)), ()=>next());
});
const userInfo = (0, _expressasynchandler.default)(async (req, res)=>{
    if (!req.user) {
        throw new _errors.ForbiddenError();
    }
    res.send((0, _utils.stripUser)(req.user));
});

//# sourceMappingURL=userMiddleware.js.map