// serverInfo must be imported before any shared modules
// so that it can set globals
// eslint-disable-next-line sort-imports
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
const _serverInfo = require("./serverInfo");
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _subCommands = /*#__PURE__*/ _interop_require_wildcard(require("./subCommands"));
const _env = require("./env");
const _database = require("./database");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
// allow commands to be hidden if e.g. they're deprecated
const hiddenCommands = [
    'migrateNotePagesToNotesCommand',
    'removeDuplicatedDischargesCommand'
];
async function run() {
    _commander.program.version(_serverInfo.version).description('Tamanu Central server').name('node dist');
    for (const [key, command] of Object.entries(_subCommands).filter(([k])=>/^\w+Command$/.test(k))){
        const hidden = hiddenCommands.includes(key);
        _commander.program.addCommand(command, {
            hidden,
            isDefault: key === 'startAllCommand'
        });
    }
    (0, _env.setupEnv)();
    await _commander.program.parseAsync(process.argv);
    _logging.log.debug('run(): closing database connection...');
    await (0, _database.closeDatabase)();
}
// catch and exit if run() throws an error
(async ()=>{
    try {
        await run();
    } catch (e) {
        _logging.log.error(`run(): fatal error: ${e.toString()}`);
        _logging.log.error(e.stack);
        process.exit(1);
    }
})();

//# sourceMappingURL=index.js.map