"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    StreamMessage: function() {
        return StreamMessage;
    },
    startStream: function() {
        return startStream;
    }
});
const _constants = require("@tamanu/constants");
function startStream(res) {
    res.writeHead(200, {
        'Content-Type': 'application/json+frame',
        'Transfer-Encoding': 'chunked'
    });
}
function shape(kind, data = undefined) {
    const dataBytes = data === undefined ? Buffer.alloc(0) : Buffer.from(JSON.stringify(data), 'utf8');
    const buf = Buffer.alloc(dataBytes.length + 8);
    buf.write('\r\n', 0);
    buf.writeUInt16BE(kind, 2);
    buf.writeUInt32BE(dataBytes.length, 4);
    dataBytes.copy(buf, 8);
    return buf;
}
const StreamMessage = {
    sessionWaiting () {
        return shape(_constants.SYNC_STREAM_MESSAGE_KIND.SESSION_WAITING);
    },
    pullWaiting () {
        return shape(_constants.SYNC_STREAM_MESSAGE_KIND.PULL_WAITING);
    },
    pullChange (data) {
        return shape(_constants.SYNC_STREAM_MESSAGE_KIND.PULL_CHANGE, data);
    },
    end (data = {}) {
        return shape(_constants.SYNC_STREAM_MESSAGE_KIND.END, Object.entries(data).length > 0 ? data : undefined);
    }
};

//# sourceMappingURL=StreamMessage.js.map