"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "registerSyncLookupUpdateListener", {
    enumerable: true,
    get: function() {
        return registerSyncLookupUpdateListener;
    }
});
const _constants = require("@tamanu/constants");
const _refreshChildRecordsForSync = require("@tamanu/shared/utils/refreshChildRecordsForSync");
const registerSyncLookupUpdateListener = async (models, dbNotifier)=>{
    const onTableChanged = dbNotifier.listeners[_constants.NOTIFY_CHANNELS.TABLE_CHANGED];
    onTableChanged(async (payload)=>{
        if (payload.event === 'UPDATE' && payload.changedColumns?.includes('patient_id')) {
            const model = Object.values(models).find((model)=>model.tableName === payload.table);
            await (0, _refreshChildRecordsForSync.refreshChildRecordsForSync)(model, payload.newId);
        }
    });
};

//# sourceMappingURL=registerSyncLookupUpdateListener.js.map