import { REFERENCE_TYPES } from './importable';
export declare const INVOICE_STATUSES: {
    CANCELLED: string;
    IN_PROGRESS: string;
    FINALISED: string;
};
export declare const INVOICE_STATUS_LABELS: {
    [INVOICE_STATUSES.CANCELLED]: string;
    [INVOICE_STATUSES.IN_PROGRESS]: string;
    [INVOICE_STATUSES.FINALISED]: string;
};
export declare const INVOICE_PAYMENT_STATUSES: {
    UNPAID: string;
    PAID: string;
    PARTIAL: string;
    REJECTED: string;
    PAID_REJECTED: string;
};
export declare const INVOICE_ITEMS_CATEGORIES: {
    PROCEDURE_TYPE: string;
    IMAGING_TYPE: string;
    IMAGING_AREA: string;
    DRUG: string;
    LAB_TEST_TYPE: string;
    LAB_TEST_PANEL: string;
};
export declare const INVOICE_PRODUCT_REFERENCE_DATA_TYPE_CATEGORIES: {
    [REFERENCE_TYPES.PROCEDURE_TYPE]: string;
    [REFERENCE_TYPES.IMAGING_TYPE]: string;
    [REFERENCE_TYPES.DRUG]: string;
};
export declare const INVOICE_ITEMS_CATEGORIES_MODELS: {
    [INVOICE_ITEMS_CATEGORIES.PROCEDURE_TYPE]: string;
    [INVOICE_ITEMS_CATEGORIES.IMAGING_TYPE]: string;
    [INVOICE_ITEMS_CATEGORIES.IMAGING_AREA]: string;
    [INVOICE_ITEMS_CATEGORIES.DRUG]: string;
    [INVOICE_ITEMS_CATEGORIES.LAB_TEST_TYPE]: string;
    [INVOICE_ITEMS_CATEGORIES.LAB_TEST_PANEL]: string;
};
export declare const INVOICE_ITEMS_CATEGORY_LABELS: {
    [INVOICE_ITEMS_CATEGORIES.PROCEDURE_TYPE]: string;
    [INVOICE_ITEMS_CATEGORIES.IMAGING_TYPE]: string;
    [INVOICE_ITEMS_CATEGORIES.IMAGING_AREA]: string;
    [INVOICE_ITEMS_CATEGORIES.DRUG]: string;
    [INVOICE_ITEMS_CATEGORIES.LAB_TEST_TYPE]: string;
    [INVOICE_ITEMS_CATEGORIES.LAB_TEST_PANEL]: string;
};
export declare const INVOICE_ITEMS_DISCOUNT_TYPES: {
    PERCENTAGE: string;
    AMOUNT: string;
};
export declare const INVOICE_PATIENT_PAYMENT_STATUSES: {
    UNPAID: string;
    PAID: string;
    PARTIAL: string;
};
export declare const INVOICE_INSURER_PAYMENT_STATUSES: {
    UNPAID: string;
    PAID: string;
    PARTIAL: string;
    REJECTED: string;
};
export declare const INVOICE_PATIENT_PAYMENT_STATUSES_LABELS: {
    [INVOICE_PATIENT_PAYMENT_STATUSES.UNPAID]: string;
    [INVOICE_PATIENT_PAYMENT_STATUSES.PAID]: string;
    [INVOICE_PATIENT_PAYMENT_STATUSES.PARTIAL]: string;
};
export declare const INVOICE_INSURER_PAYMENT_STATUS_LABELS: {
    [INVOICE_INSURER_PAYMENT_STATUSES.UNPAID]: string;
    [INVOICE_INSURER_PAYMENT_STATUSES.PAID]: string;
    [INVOICE_INSURER_PAYMENT_STATUSES.PARTIAL]: string;
    [INVOICE_INSURER_PAYMENT_STATUSES.REJECTED]: string;
};
export declare const INVOICE_PRICE_LIST_ITEM_IMPORT_VALUES: {
    HIDDEN: string;
};
export declare const AUTOMATIC_INVOICE_CREATION_EXCLUDED_ENCOUNTER_TYPES: string[];
//# sourceMappingURL=invoices.d.ts.map