"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientAdditionalData", {
    enumerable: true,
    get: function() {
        return PatientAdditionalData;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("../sync/buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("../sync/buildPatientLinkedLookupFilter");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let PatientAdditionalData = class PatientAdditionalData extends _Model.Model {
    static initModel(options) {
        super.init({
            id: {
                // patient additional data records use a patient_id as the primary key, acting as a
                // db-level enforcement of one per patient, and simplifying sync
                type: `TEXT GENERATED ALWAYS AS ("patient_id")`,
                set () {
                // any sets of the convenience generated "id" field can be ignored, so do nothing here
                }
            },
            patientId: {
                type: _sequelize.DataTypes.STRING,
                primaryKey: true,
                references: {
                    model: 'patients',
                    key: 'id'
                }
            },
            placeOfBirth: _sequelize.DataTypes.STRING,
            bloodType: _sequelize.DataTypes.STRING,
            primaryContactNumber: _sequelize.DataTypes.STRING,
            secondaryContactNumber: _sequelize.DataTypes.STRING,
            maritalStatus: _sequelize.DataTypes.STRING,
            cityTown: _sequelize.DataTypes.STRING,
            streetVillage: _sequelize.DataTypes.STRING,
            educationalLevel: _sequelize.DataTypes.STRING,
            socialMedia: _sequelize.DataTypes.STRING,
            title: _sequelize.DataTypes.STRING,
            birthCertificate: _sequelize.DataTypes.STRING,
            drivingLicense: _sequelize.DataTypes.STRING,
            passport: _sequelize.DataTypes.STRING,
            emergencyContactName: _sequelize.DataTypes.STRING,
            emergencyContactNumber: _sequelize.DataTypes.STRING,
            motherId: _sequelize.DataTypes.STRING,
            fatherId: _sequelize.DataTypes.STRING,
            healthCenterId: _sequelize.DataTypes.STRING,
            secondaryVillageId: {
                type: _sequelize.DataTypes.STRING,
                references: {
                    model: 'reference_data',
                    key: 'id'
                }
            },
            updatedAtByField: _sequelize.DataTypes.JSON,
            insurerPolicyNumber: _sequelize.DataTypes.STRING
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.User, {
            foreignKey: 'registeredById',
            as: 'registeredBy'
        });
        this.belongsTo(models.Patient, {
            foreignKey: 'motherId',
            as: 'mother'
        });
        this.belongsTo(models.Patient, {
            foreignKey: 'fatherId',
            as: 'father'
        });
        this.belongsTo(models.Facility, {
            foreignKey: 'healthCenterId',
            as: 'healthCenter'
        });
        const referenceRelation = (name)=>this.belongsTo(models.ReferenceData, {
                foreignKey: `${name}Id`,
                as: name
            });
        referenceRelation('nationality');
        referenceRelation('country');
        referenceRelation('division');
        referenceRelation('subdivision');
        referenceRelation('medicalArea');
        referenceRelation('nursingZone');
        referenceRelation('settlement');
        referenceRelation('ethnicity');
        referenceRelation('occupation');
        referenceRelation('religion');
        referenceRelation('patientBillingType');
        referenceRelation('countryOfBirth');
        referenceRelation('insurer');
    }
    static getFullReferenceAssociations() {
        return [
            'countryOfBirth',
            'country',
            'nationality',
            'ethnicity',
            'insurer'
        ];
    }
    static async buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
    static async getForPatient(patientId) {
        return this.findOne({
            where: {
                patientId
            }
        });
    }
    static async getOrCreateForPatient(patientId) {
        // See if there's an existing PAD we can use
        const existing = await this.getForPatient(patientId);
        if (existing) {
            return existing;
        }
        // otherwise create a new one
        return this.create({
            patientId
        });
    }
    static async updateForPatient(patientId, values) {
        const additionalData = await this.getOrCreateForPatient(patientId);
        await additionalData.update(values);
        return additionalData;
    }
};
_define_property(PatientAdditionalData, "buildPatientSyncFilter", _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientAdditionalData.js.map